/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.config.option;

import com.bejker.interactionmanager.config.option.IOptionConvertable;
import com.bejker.interactionmanager.config.option.OptionStorage;
import com.bejker.interactionmanager.util.Util;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

public class EnumOption<E extends Enum<E>>
implements IOptionConvertable {
    private final String key;
    private final String translation_key;
    private final String tooltip_key;
    private final Class<E> enum_class;
    private final E default_value;
    private static final String TRANSLATION_KEY_TYPE = "option";

    public EnumOption(String key, E default_value) {
        this.key = key;
        this.translation_key = Util.translationKeyOf(TRANSLATION_KEY_TYPE, key);
        this.tooltip_key = Util.getTooltipTranslationKey(TRANSLATION_KEY_TYPE, key);
        this.enum_class = ((Enum)default_value).getDeclaringClass();
        this.default_value = default_value;
        this.setValue(default_value);
    }

    public String getKey() {
        return this.key;
    }

    public E getValue() {
        return OptionStorage.getEnum(this.key, this.enum_class);
    }

    public void setValue(E value) {
        OptionStorage.setEnum(this.key, value);
    }

    public void cycleValue(int amount) {
        OptionStorage.cycleEnumValue(this.key, this.enum_class, amount);
    }

    public void nextValue() {
        this.cycleValue(1);
    }

    public E getDefaultValue() {
        return this.default_value;
    }

    private static <E extends Enum<E>> class_2561 getValueText(EnumOption<E> option, E value) {
        return class_2561.method_43471((String)(option.translation_key + "." + value.name().toLowerCase(Locale.ROOT)));
    }

    public class_2561 getButtonText() {
        return class_5244.method_32700((class_2561)class_2561.method_43471((String)this.translation_key), (class_2561)EnumOption.getValueText(this, this.getValue()));
    }

    @Override
    public class_7172<?> asOption() {
        return new class_7172(this.translation_key, class_2564.method_43476((class_2561)class_2561.method_43471((String)this.tooltip_key)) ? class_7172.method_42717((class_2561)class_2561.method_43471((String)this.tooltip_key)) : class_7172.method_42399(), (text, value) -> EnumOption.getValueText(this, value), (class_7172.class_7178)new class_7172.class_7173(Arrays.asList((Enum[])this.enum_class.getEnumConstants()), Codec.STRING.xmap(string -> Arrays.stream((Enum[])this.enum_class.getEnumConstants()).filter(e -> e.name().toLowerCase().equals(string)).findAny().orElse(null), newValue -> newValue.name().toLowerCase())), this.getValue(), new_value -> OptionStorage.setEnum(this.key, new_value));
    }
}

