/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.search;

import com.bejker.interactionmanager.search.Edge;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class EdgeBag
implements Map<Character, Edge> {
    private byte[] chars;
    private Edge[] values;
    private static final int BSEARCH_THRESHOLD = 6;

    EdgeBag() {
    }

    @Override
    public Edge put(Character character, Edge e) {
        char c = character.charValue();
        if (c != (char)c) {
            throw new IllegalArgumentException("Illegal input character " + c + ".");
        }
        if (this.chars == null) {
            this.chars = new byte[0];
            this.values = new Edge[0];
        }
        int idx = this.search(c);
        Edge previous = null;
        if (idx < 0) {
            int currsize = this.chars.length;
            byte[] copy = new byte[currsize + 1];
            System.arraycopy(this.chars, 0, copy, 0, currsize);
            this.chars = copy;
            Edge[] copy1 = new Edge[currsize + 1];
            System.arraycopy(this.values, 0, copy1, 0, currsize);
            this.values = copy1;
            this.chars[currsize] = (byte)c;
            this.values[currsize] = e;
            if (++currsize > 6) {
                this.sortArrays();
            }
        } else {
            previous = this.values[idx];
            this.values[idx] = e;
        }
        return previous;
    }

    @Override
    public Edge get(Object maybeCharacter) {
        return this.get(((Character)maybeCharacter).charValue());
    }

    public Edge get(char c) {
        if (c != (char)c) {
            throw new IllegalArgumentException("Illegal input character " + c + ".");
        }
        int idx = this.search(c);
        if (idx < 0) {
            return null;
        }
        return this.values[idx];
    }

    private int search(char c) {
        if (this.chars == null) {
            return -1;
        }
        if (this.chars.length > 6) {
            return Arrays.binarySearch(this.chars, (byte)c);
        }
        for (int i = 0; i < this.chars.length; ++i) {
            if (c != this.chars[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Collection<Edge> values() {
        return Arrays.asList(this.values == null ? new Edge[]{} : this.values);
    }

    private void sortArrays() {
        for (int i = 0; i < this.chars.length; ++i) {
            for (int j = i; j > 0; --j) {
                if (this.chars[j - 1] <= this.chars[j]) continue;
                byte swap = this.chars[j];
                this.chars[j] = this.chars[j - 1];
                this.chars[j - 1] = swap;
                Edge swapEdge = this.values[j];
                this.values[j] = this.values[j - 1];
                this.values[j - 1] = swapEdge;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.chars == null || this.chars.length == 0;
    }

    @Override
    public int size() {
        return this.chars == null ? 0 : this.chars.length;
    }

    @Override
    public Set<Map.Entry<Character, Edge>> entrySet() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Set<Character> keySet() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Edge> m) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Edge remove(Object key) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean containsValue(Object key) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

