/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.search;

import com.bejker.interactionmanager.search.GeneralizedSuffixTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_7923;

public class SearchUtil {
    private static SearchTree<class_2248> blockNameTree;

    public static void init() {
        blockNameTree = new SearchTree();
        for (class_2248 block : class_7923.field_41175) {
            blockNameTree.put(SearchUtil.getLocalizedBlockName(block), block);
        }
    }

    public static Collection<class_2248> searchBlocks(String word, int results) {
        return blockNameTree.search(word, results);
    }

    public static String getLocalizedBlockName(class_2248 block) {
        return ((String)block.method_9518().method_10851().method_27659(Optional::of).get()).toLowerCase(Locale.ROOT);
    }

    private static class SearchTree<T> {
        GeneralizedSuffixTree tree = new GeneralizedSuffixTree();
        ArrayList<T> list = new ArrayList();
        private int idx = 0;

        public void put(String word, T entry) {
            this.tree.put(word, this.idx++);
            this.list.add(entry);
        }

        public Collection<T> search(String word) {
            return this.search(word, -1);
        }

        public Collection<T> search(String word, int results) {
            return this.tree.search(word, results).stream().map(i -> this.list.get((int)i)).toList();
        }
    }
}

