/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.gui.widget;

import com.bejker.interactionmanager.config.Config;
import com.bejker.interactionmanager.gui.options.denylist.ItemInteractionsScreen;
import com.bejker.interactionmanager.gui.widget.SearchableListWidget;
import com.bejker.interactionmanager.search.SearchUtil;
import com.bejker.interactionmanager.util.Util;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_6379;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8666;

public class ItemInteractionListWidget
extends SearchableListWidget<ItemInteractionsScreen> {
    public ItemInteractionListWidget(ItemInteractionsScreen parent, class_310 client) {
        super(parent, client, parent.field_22789 / 2 - 5, parent.field_49503.method_57727(), parent.field_49503.method_48998(), 23);
    }

    @Override
    public void updateEntries() {
        boolean overridesUse;
        super.updateEntries();
        if (((ItemInteractionsScreen)this.parent).getSelectedItem() == null) {
            return;
        }
        boolean isAllSelected = class_1802.field_8162 == ((ItemInteractionsScreen)this.parent).getSelectedItem();
        boolean overridesUseOnBlock = isAllSelected || Util.doesOverrideMethod(((ItemInteractionsScreen)this.parent).getSelectedItem().getClass(), "useOnBlock", class_1792.class);
        boolean bl = overridesUse = isAllSelected || Util.doesOverrideMethod(((ItemInteractionsScreen)this.parent).getSelectedItem().getClass(), "use", class_1792.class);
        if (overridesUseOnBlock && this.lastSearch != null && !this.lastSearch.isBlank()) {
            SearchUtil.searchBlocks(this.lastSearch, -1, x -> !x.equals(class_2246.field_10124)).stream().distinct().map(x$0 -> new SearchBlockEntry((class_2248)x$0)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        } else {
            HashSet<class_2248> blocks;
            if (overridesUseOnBlock) {
                this.method_25321((class_350.class_351)new AllEntry(this));
            }
            if (overridesUse) {
                this.method_25321((class_350.class_351)new UseEntry());
            }
            if ((blocks = Config.DENIED_ITEM_INTERACTIONS.get(((ItemInteractionsScreen)this.parent).getSelectedItem())) != null) {
                for (class_2248 i : blocks) {
                    if (i == class_2246.field_10124) continue;
                    this.method_25321((class_350.class_351)new BlockEntry(i));
                }
            }
        }
    }

    @Override
    protected void updateSearch() {
        String search = ((ItemInteractionsScreen)this.parent).getBlockSearch();
        if (!search.equals(this.lastSearch)) {
            this.lastSearch = search;
            this.updateEntries();
        }
    }

    public class AllEntry
    extends SearchBlockEntry {
        public AllEntry(ItemInteractionListWidget this$0) {
            super(class_2246.field_10124);
            this.block_name_text = class_2561.method_43471((String)"text.interactionmanager.deny_using_on_all_blocks.title");
            this.block_id_text = class_2561.method_43471((String)"text.interactionmanager.deny_using_on_all_blocks.tooltip");
            this.borderColor = -55924054;
            this.bgColor = -888205553;
        }
    }

    private class UseEntry
    extends AllEntry {
        public UseEntry() {
            super(ItemInteractionListWidget.this);
            this.block_name_text = class_2561.method_43471((String)"text.interactionmanager.deny_using_item.title");
            this.block_id_text = class_2561.method_43471((String)"text.interactionmanager.deny_using_item.tooltip");
            this.borderColor = -55924054;
            this.bgColor = -888205553;
        }

        @Override
        class_4185 createButton(class_2248 block) {
            boolean initialButtonState = !Config.DENIED_ITEMS.contains(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem());
            return new class_344(20, 20, initialButtonState ? BUTTON_TEXTURES_REJECT : BUTTON_TEXTURES_ACCEPT, button -> {
                if (((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem() == null) {
                    return;
                }
                if (initialButtonState) {
                    Config.DENIED_ITEMS.add(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem());
                } else {
                    Config.DENIED_ITEMS.remove(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem());
                }
                ItemInteractionListWidget.this.updateEntries();
            }, (class_2561)class_2561.method_43471((String)"button.interactionmanager.remove"));
        }
    }

    public class BlockEntry
    extends SearchableListWidget.Entry {
        public class_2561 block_name_text;
        public class_2561 block_id_text;
        private final class_4185 button;
        private final class_2248 block;
        private static final int MAX_CHARS = 30;
        static final class_8666 BUTTON_TEXTURES = new class_8666(class_2960.method_60656((String)"pending_invite/accept"), class_2960.method_60656((String)"pending_invite/accept_highlighted"));

        public BlockEntry(class_2248 block) {
            super(ItemInteractionListWidget.this);
            class_6880 entry = class_7923.field_41175.method_47983((Object)block);
            this.block_name_text = class_2561.method_30163((String)block.method_9518().method_10858(30));
            String id = entry.method_55840();
            this.block_id_text = class_2561.method_43470((String)id.substring(0, Math.min(id.length(), 30))).method_54663(-8355712);
            this.button = this.createButton(block);
            this.block = block;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return super.method_25402(mouseX, mouseY, button);
        }

        class_4185 createButton(class_2248 block) {
            return new class_344(20, 20, BUTTON_TEXTURES, button -> this.removeEntry(block), (class_2561)class_2561.method_43471((String)"button.interactionmanager.remove"));
        }

        protected void removeEntry(class_2248 block) {
            if (((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem() == null) {
                return;
            }
            HashSet<class_2248> deniedBlocks = Config.DENIED_ITEM_INTERACTIONS.get(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem());
            if (deniedBlocks != null) {
                deniedBlocks.remove(block);
            }
            Config.DENIED_ITEM_INTERACTIONS.put(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem(), deniedBlocks);
            ItemInteractionListWidget.this.updateEntries();
            ((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).updateItems();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int ref_x = x + entryWidth / 32;
            if (Config.RENDER_ITEMS_IN_BLOCK_DENY_LIST.getValue()) {
                ref_x += 14;
            }
            int ref_y = y + entryHeight - 9;
            context.method_27535(((ItemInteractionListWidget)ItemInteractionListWidget.this).field_22740.field_1772, this.block_name_text, ref_x, ref_y, -1);
            context.method_27535(((ItemInteractionListWidget)ItemInteractionListWidget.this).field_22740.field_1772, this.block_id_text, ref_x, ref_y + 10, -8355712);
            this.button.method_46421(x + entryWidth - this.button.method_25368() - 3);
            this.button.method_46419(ref_y - 1);
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
            if (Config.RENDER_ITEMS_IN_BLOCK_DENY_LIST.getValue()) {
                context.method_51445(new class_1799((class_1935)this.block), ref_x - 20, ref_y);
            }
        }
    }

    public class SearchBlockEntry
    extends BlockEntry {
        private static final int lines = 2;
        protected int borderColor;
        protected int bgColor;
        static final class_8666 BUTTON_TEXTURES_REJECT = new class_8666(class_2960.method_60656((String)"pending_invite/reject"), class_2960.method_60656((String)"pending_invite/reject_highlighted"));
        static final class_8666 BUTTON_TEXTURES_ACCEPT = new class_8666(class_2960.method_60656((String)"pending_invite/accept"), class_2960.method_60656((String)"pending_invite/accept_highlighted"));

        public SearchBlockEntry(class_2248 block) {
            super(block);
            this.borderColor = 0xFBABABA;
            this.bgColor = 0x10AAAAAA;
        }

        @Override
        class_4185 createButton(class_2248 block) {
            HashSet<class_2248> initiallyDeniedBlocks = Config.DENIED_ITEM_INTERACTIONS.get(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem());
            boolean initialButtonState = initiallyDeniedBlocks == null || !initiallyDeniedBlocks.contains(block);
            return new class_344(20, 20, initialButtonState ? BUTTON_TEXTURES_REJECT : BUTTON_TEXTURES_ACCEPT, button -> {
                if (initialButtonState) {
                    this.addEntry(block);
                } else {
                    this.removeEntry(block);
                }
            }, (class_2561)class_2561.method_43471((String)"button.interactionmanager.remove"));
        }

        void addEntry(class_2248 block) {
            if (((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem() == null) {
                return;
            }
            HashSet<Object> deniedBlocks = Config.DENIED_ITEM_INTERACTIONS.get(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem());
            if (deniedBlocks == null) {
                deniedBlocks = new HashSet();
            }
            deniedBlocks.add(block);
            Config.DENIED_ITEM_INTERACTIONS.put(((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).getSelectedItem(), deniedBlocks);
            ((ItemInteractionsScreen)ItemInteractionListWidget.this.parent).updateItems();
            ItemInteractionListWidget.this.updateEntries();
        }

        public void method_49568(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int ref_y = y + entryHeight - 9 - 1;
            context.method_49601(x - 2, ref_y - 2, entryWidth, entryHeight * 2 - 2, this.borderColor);
            context.method_25294(x - 1, ref_y - 1, x + entryWidth - 3, ref_y + entryHeight * 2 - 5, this.bgColor);
        }
    }
}

