/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.config;

import com.bejker.interactionmanager.InteractionManager;
import com.bejker.interactionmanager.config.Config;
import com.bejker.interactionmanager.config.option.BooleanOption;
import com.bejker.interactionmanager.config.option.EnumOption;
import com.bejker.interactionmanager.config.option.OptionStorage;
import com.bejker.interactionmanager.config.option.interfaces.IFileOnlyOption;
import com.bejker.interactionmanager.config.option.interfaces.IOptionConvertable;
import com.bejker.interactionmanager.config.option.interfaces.IRuntimeInternalOnlyOption;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static Path config_path;
    static Logger LOGGER;

    public static void loadConfig() {
        ConfigManager.setupConfigFile();
        if (!Files.exists(config_path, new LinkOption[0])) {
            ConfigManager.saveConfig();
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(config_path);
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            boolean found_invalid = false;
            for (Field field : Config.class.getDeclaredFields()) {
                JsonObject jsonObject;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class)) continue;
                String field_name = field.getName().toLowerCase(Locale.ROOT);
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    BooleanOption option = (BooleanOption)field.get(null);
                    JsonPrimitive value = json.getAsJsonPrimitive(field_name);
                    if (value == null) continue;
                    option.setValue(value.getAsBoolean());
                    continue;
                }
                if (EnumOption.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                    Type generic;
                    JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT));
                    if (jsonPrimitive == null || !jsonPrimitive.isString() || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                    EnumOption enumOption = (EnumOption)field.get(null);
                    Enum found = null;
                    ArrayList<CallSite> valid_values = new ArrayList<CallSite>();
                    for (Enum value : (Enum[])((Class)generic).getEnumConstants()) {
                        String value_name = value.name().toLowerCase(Locale.ROOT);
                        valid_values.add((CallSite)((Object)("\"" + value_name + "\"")));
                        if (!value_name.equals(jsonPrimitive.getAsString())) continue;
                        found = value;
                        break;
                    }
                    if (found != null) {
                        OptionStorage.setEnumRaw(enumOption.getKey(), found);
                        continue;
                    }
                    LOGGER.error("Invalid option in Interaction Manager config; Path: \"{}\": \"{}\":\"{}\"; Restoring saved: \"{}\"; Valid values: {}", new Object[]{config_path, enumOption.getKey(), jsonPrimitive.getAsString(), ((Enum)enumOption.getValue()).name().toLowerCase(Locale.ROOT), valid_values});
                    found_invalid = true;
                    continue;
                }
                if (Set.class.isAssignableFrom(field.getType())) {
                    class_2960 id;
                    JsonArray jsonArray;
                    if (field.getName().equals("DENIED_BLOCKS")) {
                        jsonArray = json.getAsJsonArray(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonArray == null || jsonArray.isEmpty()) continue;
                        for (JsonElement jsonElement : jsonArray) {
                            id = ConfigManager.elem2Id(jsonElement);
                            if (id == null) continue;
                            class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
                            Config.DENIED_BLOCKS.add(block);
                        }
                        continue;
                    }
                    if (field.getName().equals("DENIED_ENTITIES")) {
                        jsonArray = json.getAsJsonArray(field.getName().toLowerCase(Locale.ROOT));
                        if (jsonArray == null || jsonArray.isEmpty()) continue;
                        for (JsonElement jsonElement : jsonArray) {
                            id = ConfigManager.elem2Id(jsonElement);
                            if (id == null) continue;
                            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(id);
                            Config.DENIED_ENTITIES.add(entityType);
                        }
                        continue;
                    }
                    if (!field.getName().equals("DENIED_ITEMS") || (jsonArray = json.getAsJsonArray(field.getName().toLowerCase(Locale.ROOT))) == null || jsonArray.isEmpty()) continue;
                    for (JsonElement jsonElement : jsonArray) {
                        id = ConfigManager.elem2Id(jsonElement);
                        if (id == null) continue;
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
                        Config.DENIED_ITEMS.add(item);
                    }
                    continue;
                }
                if (!HashMap.class.isAssignableFrom(field.getType()) || !field.getName().equals("DENIED_ITEM_INTERACTIONS") || (jsonObject = json.getAsJsonObject(field.getName().toLowerCase(Locale.ROOT))) == null) continue;
                for (Map.Entry entry : jsonObject.asMap().entrySet()) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)((String)entry.getKey())));
                    HashSet<class_2248> set = new HashSet<class_2248>();
                    JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                    for (JsonElement blockName : jsonArray) {
                        class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)blockName.getAsString()));
                        set.add(block);
                    }
                    Config.DENIED_ITEM_INTERACTIONS.put(item, set);
                }
            }
            if (found_invalid) {
                ConfigManager.saveConfig();
            }
        }
        catch (IOException | IllegalAccessException e) {
            LOGGER.error("Couldn't load Interaction Manager config, using defaults.");
            e.printStackTrace();
        }
    }

    private static class_2960 elem2Id(JsonElement element) {
        try {
            String id_str = element.getAsString();
            class_2960 id = class_2960.method_12829((String)id_str);
            if (id == null) {
                LOGGER.error("'{}' couldn't be converted to a valid minecraft identifier", (Object)id_str);
            }
            return id;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveConfig() {
        ConfigManager.setupConfigFile();
        JsonObject config = new JsonObject();
        try {
            for (Field field : Config.class.getDeclaredFields()) {
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class)) continue;
                String fieldName = field.getName().toLowerCase(Locale.ROOT);
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    BooleanOption option = (BooleanOption)field.get(null);
                    if (option.getValue() == option.getDefaultValue()) continue;
                    config.addProperty(fieldName, Boolean.valueOf(option.getValue()));
                    continue;
                }
                if (EnumOption.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                    EnumOption option;
                    Type generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    if (!(generic instanceof Class) || (option = (EnumOption)field.get(null)).getValue() == option.getDefaultValue()) continue;
                    config.addProperty(field.getName().toLowerCase(Locale.ROOT), OptionStorage.getEnumRaw(option.getKey(), (Class)generic).name().toLowerCase(Locale.ROOT));
                    continue;
                }
                if (Set.class.isAssignableFrom(field.getType())) {
                    JsonArray array;
                    if (field.getName().equals("DENIED_BLOCKS")) {
                        array = new JsonArray();
                        for (class_2248 block2 : Config.DENIED_BLOCKS) {
                            array.add(class_7923.field_41175.method_10221((Object)block2).toString());
                        }
                        if (array.isEmpty()) continue;
                        config.add(fieldName, (JsonElement)array);
                        continue;
                    }
                    if (field.getName().equals("DENIED_ENTITIES")) {
                        array = new JsonArray();
                        for (class_1299<?> entityType : Config.DENIED_ENTITIES) {
                            array.add(class_7923.field_41177.method_10221(entityType).toString());
                        }
                        if (array.isEmpty()) continue;
                        config.add(fieldName, (JsonElement)array);
                        continue;
                    }
                    if (!field.getName().equals("DENIED_ITEMS")) continue;
                    array = new JsonArray();
                    for (class_1792 item : Config.DENIED_ITEMS) {
                        array.add(class_7923.field_41178.method_10221((Object)item).toString());
                    }
                    if (array.isEmpty()) continue;
                    config.add(fieldName, (JsonElement)array);
                    continue;
                }
                if (!HashMap.class.isAssignableFrom(field.getType()) || !field.getName().equals("DENIED_ITEM_INTERACTIONS")) continue;
                JsonObject jsonObject = new JsonObject();
                boolean shouldSave = false;
                for (Map.Entry<class_1792, HashSet<class_2248>> entry : Config.DENIED_ITEM_INTERACTIONS.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    JsonArray jsonArray = new JsonArray();
                    entry.getValue().forEach(block -> jsonArray.add(class_7923.field_41175.method_10221(block).toString()));
                    jsonObject.add(class_7923.field_41178.method_10221((Object)entry.getKey()).toString(), (JsonElement)jsonArray);
                    if (jsonArray.isEmpty()) continue;
                    shouldSave = true;
                }
                if (!shouldSave) continue;
                config.add(fieldName, (JsonElement)jsonObject);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String string = InteractionManager.GSON.toJson((JsonElement)config);
        try {
            BufferedWriter writer = Files.newBufferedWriter(config_path, new OpenOption[0]);
            writer.write(string);
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save Interaction Manager config.");
            e.printStackTrace();
        }
    }

    public static void restoreDefaults(Class<? extends Annotation> target) {
        try {
            for (Field field : Config.class.getDeclaredFields()) {
                IOptionConvertable option;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class) || field.isAnnotationPresent(IFileOnlyOption.class) || target != null && !field.isAnnotationPresent(target)) continue;
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    option = (BooleanOption)field.get(null);
                    OptionStorage.setBoolean(((BooleanOption)option).getKey(), ((BooleanOption)option).getDefaultValue());
                    continue;
                }
                if (!EnumOption.class.isAssignableFrom(field.getType())) continue;
                option = (EnumOption)field.get(null);
                OptionStorage.setEnumRaw(((EnumOption)option).getKey(), ((EnumOption)option).getDefaultValue());
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Couldn't restore Interaction Manager config to defaults.");
            e.printStackTrace();
        }
    }

    public static boolean areOptionValuesSetToDefault(Class<? extends Annotation> target) {
        try {
            for (Field field : Config.class.getDeclaredFields()) {
                IOptionConvertable option;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class) || field.isAnnotationPresent(IFileOnlyOption.class) || target != null && !field.isAnnotationPresent(target) || !(BooleanOption.class.isAssignableFrom(field.getType()) ? ((BooleanOption)(option = (BooleanOption)field.get(null))).getValue() != ((BooleanOption)option).getDefaultValue() : EnumOption.class.isAssignableFrom(field.getType()) && ((EnumOption)(option = (EnumOption)field.get(null))).getValue() != ((EnumOption)option).getDefaultValue())) continue;
                return false;
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Couldn't check if Interaction Manager config is set to defaults.");
            e.printStackTrace();
        }
        return true;
    }

    public static void initRuntimeOptions() {
        Config.IS_MODMENU_INSTALLED.setValue(FabricLoader.getInstance().getModContainer("modmenu").isPresent());
    }

    private static void setupConfigFile() {
        if (config_path != null) {
            return;
        }
        config_path = FabricLoader.getInstance().getConfigDir().resolve("interactionmanager.json");
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"interactionmanager | ConfigManager");
    }
}

