/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.search;

import com.bejker.interactionmanager.InteractionManager;
import com.bejker.interactionmanager.search.GeneralizedSuffixTree;
import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class SearchUtil {
    private static final int MAX_SEARCH_TERM_LEN = 40;
    private static final SearchTree<class_2248> blockSearchTree = new SearchTree();
    private static final SearchTree<class_1299<?>> entitySearchTree = new SearchTree();
    private static final SearchTree<class_1792> itemSearchTree = new SearchTree();
    private static final ImmutableSet<String> allSearchTreeNames = ImmutableSet.of((Object)"block", (Object)"entity", (Object)"item");
    private static String currentLanguage;
    private static ImmutableSet<String> currentResourcePacks;
    private static final HashMap<class_3545<String, String>, Integer> lsdCache;

    public static void init() {
        SearchUtil.init(false);
    }

    public static void init(boolean force) {
        String language = class_310.method_1551().method_1526().method_4669();
        ImmutableSet resourcePacks = (ImmutableSet)class_310.method_1551().method_1520().method_29210();
        if (!force && language.equals(currentLanguage) && SearchUtil.blockSearchTree.list.size() == class_7923.field_41175.method_10204() && SearchUtil.entitySearchTree.list.size() == class_7923.field_41177.method_10204() && SearchUtil.itemSearchTree.list.size() == class_7923.field_41178.method_10204() && Objects.equals(resourcePacks, currentResourcePacks)) {
            return;
        }
        currentLanguage = language;
        currentResourcePacks = resourcePacks;
        blockSearchTree.clear();
        entitySearchTree.clear();
        itemSearchTree.clear();
        HashSet<String> builtSearchTrees = new HashSet<String>();
        StringWriter errorStringWriter = new StringWriter();
        try {
            SearchUtil.internalInit(builtSearchTrees);
        }
        catch (Exception e) {
            PrintWriter printWriter = new PrintWriter(errorStringWriter);
            e.printStackTrace(printWriter);
        }
        if (!errorStringWriter.toString().isBlank()) {
            StringBuilder failedToBuildS = new StringBuilder();
            List<String> failedToBuild = allSearchTreeNames.stream().filter(x -> !builtSearchTrees.contains(x)).toList();
            for (String i : failedToBuild) {
                failedToBuildS.append(i).append(", ");
            }
            InteractionManager.LOGGER.error("Failed to build search tree{}: {}with error:\n{}", new Object[]{failedToBuild.size() == 1 ? "" : "s", failedToBuildS, errorStringWriter});
            return;
        }
        InteractionManager.LOGGER.info("Built search trees");
    }

    private static void internalInit(HashSet<String> builtSearchTrees) {
        class_6880 entry;
        for (class_2248 block : class_7923.field_41175) {
            entry = class_7923.field_41175.method_47983((Object)block);
            blockSearchTree.put(SearchUtil.getNamespace(entry), SearchUtil.getLocalizedName((class_2561)block.method_9518()), block);
        }
        builtSearchTrees.add("block");
        for (class_1299 entity_type : class_7923.field_41177) {
            entry = class_7923.field_41177.method_47983((Object)entity_type);
            entitySearchTree.put(SearchUtil.getNamespace(entry), SearchUtil.getLocalizedName(entity_type.method_5897()), entity_type);
        }
        builtSearchTrees.add("entity");
        for (class_1792 item : class_7923.field_41178) {
            entry = class_7923.field_41178.method_47983((Object)item);
            itemSearchTree.put(SearchUtil.getNamespace(entry), SearchUtil.getLocalizedName(item.method_7848()), item);
        }
        builtSearchTrees.add("item");
    }

    private static String getNamespace(class_6880<?> entry) {
        String idString = entry.method_55840();
        int idx = idString.lastIndexOf(58);
        if (idx == -1) {
            InteractionManager.LOGGER.warn("{} doesn't have a namespace!", (Object)entry.method_40230());
            return "";
        }
        String namespaceString = idString.substring(0, idx);
        return namespaceString.toLowerCase(Locale.ROOT);
    }

    public static Collection<class_2248> searchBlocks(String word, int results, Predicate<? super class_2248> filterPredicate) {
        SearchUtil.init();
        return blockSearchTree.search(word, results).stream().distinct().filter(filterPredicate).sorted(Comparator.comparingInt(x -> SearchUtil.modLSD(SearchUtil.getLocalizedName((class_2561)x.method_9518()), word, 0))).toList();
    }

    public static Collection<class_1299<?>> searchEntities(String word, int results, Predicate<? super class_1299<?>> filterPredicate) {
        SearchUtil.init();
        return entitySearchTree.search(word, results).stream().distinct().filter(filterPredicate).sorted(Comparator.comparingInt(x -> SearchUtil.modLSD(SearchUtil.getLocalizedName(x.method_5897()), word, 0))).toList();
    }

    public static String getLocalizedName(class_2561 text) {
        String content = (String)text.method_10851().method_27659(Optional::of).get();
        return content.substring(0, Math.min(content.length(), 40)).toLowerCase(Locale.ROOT);
    }

    public static Collection<class_1792> searchItems(String word, int results, Predicate<? super class_1792> filterPredicate) {
        SearchUtil.init();
        return itemSearchTree.search(word, results).stream().distinct().filter(filterPredicate).sorted(Comparator.comparingInt(x -> SearchUtil.modLSD(SearchUtil.getLocalizedName(x.method_7848()), word, 0))).toList();
    }

    private static int modLSD(String search, String word, int curr) {
        int CUTOFF = 3;
        if (curr >= 3) {
            return Math.max(search.length(), word.length());
        }
        class_3545 pair = new class_3545((Object)search, (Object)word);
        Integer ret = lsdCache.get(pair);
        if (ret != null) {
            return ret;
        }
        if (search.isBlank()) {
            return word.length();
        }
        if (word.isBlank()) {
            return search.length();
        }
        String searchTail = search.substring(1);
        String wordTail = word.substring(1);
        if (search.charAt(0) == word.charAt(0)) {
            ret = SearchUtil.modLSD(searchTail, wordTail, curr + 1);
            lsdCache.put((class_3545<String, String>)pair, ret);
            return ret;
        }
        ret = 1 + Math.min(Math.min(SearchUtil.modLSD(searchTail, word, curr + 1), SearchUtil.modLSD(search, wordTail, curr + 1)), SearchUtil.modLSD(searchTail, wordTail, curr + 1));
        lsdCache.put((class_3545<String, String>)pair, ret);
        return ret;
    }

    static {
        lsdCache = new HashMap();
    }

    private static class SearchTree<T> {
        GeneralizedSuffixTree tree;
        final ArrayList<T> list = new ArrayList();
        final ArrayList<String> namespaceList = new ArrayList();
        private int idx;

        public SearchTree() {
            this.clear();
        }

        public void clear() {
            this.tree = new GeneralizedSuffixTree();
            this.list.clear();
            this.namespaceList.clear();
            this.idx = 0;
        }

        public void put(String namespace, String word, T entry) {
            word = word.toLowerCase(Locale.ROOT);
            try {
                this.tree.put(word, this.idx);
            }
            catch (NullPointerException e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                e.printStackTrace(writer);
                InteractionManager.LOGGER.error("Failed to put word in a search tree. It's likely because it contains non-UTF-8 characters, culprit word: '{}', error:\n{}", (Object)word, (Object)stringWriter);
            }
            this.list.add(entry);
            this.namespaceList.add(namespace);
            ++this.idx;
        }

        private T mapIndexToEntry(int i) {
            return this.list.get(i);
        }

        private Stream<Integer> rawSearch(String word, int results) {
            return this.tree.search(word.toLowerCase(Locale.ROOT), results).stream();
        }

        public Collection<T> search(String word, int results) {
            int startNamespaceIdx = (word = word.toLowerCase(Locale.ROOT)).indexOf(64) + 1;
            if (startNamespaceIdx != 0 && startNamespaceIdx < word.length()) {
                int endNamespaceIdx = word.substring(startNamespaceIdx, word.length() - 1).indexOf(" ");
                endNamespaceIdx = endNamespaceIdx == -1 ? word.length() : (endNamespaceIdx += startNamespaceIdx);
                String namespace = word.substring(startNamespaceIdx, endNamespaceIdx);
                word = (word.substring(0, startNamespaceIdx - 1) + word.substring(endNamespaceIdx)).trim();
                return this.search(namespace, word, results);
            }
            if (word.length() > 1 && startNamespaceIdx == word.length()) {
                word = word.substring(0, word.length() - 2).trim();
            }
            return this.rawSearch(word, results).map(this::mapIndexToEntry).toList();
        }

        public Collection<T> search(String namespace, String word, int results) {
            return this.rawSearch(word, results).filter(idx -> this.filterByNamespace(namespace, (Integer)idx)).map(this::mapIndexToEntry).toList();
        }

        private boolean filterByNamespace(String namespace, Integer idx) {
            if (idx == null) {
                return false;
            }
            String foundNamespace = this.namespaceList.get(idx);
            if (foundNamespace == null) {
                return false;
            }
            int matchIdx = foundNamespace.indexOf(namespace);
            return matchIdx == 0;
        }
    }
}

