/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.client.config;

import com.bejker.interactionmanager.InteractionManager;
import com.bejker.interactionmanager.client.InteractionManagerClient;
import com.bejker.interactionmanager.client.config.option.BooleanOption;
import com.bejker.interactionmanager.client.config.option.ConfigStorage;
import com.bejker.interactionmanager.client.config.option.EnumOption;
import com.bejker.interactionmanager.client.config.option.IFileOnlyOption;
import com.bejker.interactionmanager.client.config.option.IOptionConvertable;
import com.bejker.interactionmanager.client.config.option.IRuntimeInternalOnlyOption;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_7172;

public class InteractionManagerConfig {
    private static Path config_path;
    public static final BooleanOption ALLOW_SHOVEL_CREATE_PATHS;
    public static final BooleanOption ALLOW_AXE_STRIP_BLOCKS;
    public static final BooleanOption ALLOW_USE_FIREWORK_ON_BLOCK;
    public static final BooleanOption ALLOW_ATTACKING_HOSTILE_ENTITIES;
    public static final BooleanOption ALLOW_ATTACKING_PASSIVE_ENTITIES;
    public static final BooleanOption ALLOW_ATTACKING_VILLAGERS;
    public static final EnumOption<PetAttackMode> PET_ATTACK_MODE;
    @IRuntimeInternalOnlyOption
    public static final BooleanOption IS_MODMENU_INSTALLED;
    @IFileOnlyOption
    public static final EnumOption<ShouldAddInteractionsButton> SHOULD_ADD_INTERACTIONS_BUTTON;

    private static void setupConfigFile() {
        if (config_path != null) {
            return;
        }
        config_path = FabricLoader.getInstance().getConfigDir().resolve("interactionmanager.json");
    }

    public static class_7172<?>[] asOptions() {
        ArrayList options = new ArrayList();
        for (Field field : InteractionManagerConfig.class.getDeclaredFields()) {
            if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class) || field.isAnnotationPresent(IFileOnlyOption.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !IOptionConvertable.class.isAssignableFrom(field.getType())) continue;
            try {
                options.add(((IOptionConvertable)field.get(null)).asOption());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return (class_7172[])options.stream().toArray(class_7172[]::new);
    }

    public static void loadConfig() {
        InteractionManagerConfig.setupConfigFile();
        if (!Files.exists(config_path, new LinkOption[0])) {
            InteractionManagerConfig.saveConfig();
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(config_path);
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            boolean found_invalid = false;
            for (Field field : InteractionManagerConfig.class.getDeclaredFields()) {
                Type generic;
                JsonPrimitive jsonPrimitive;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class)) continue;
                String field_name = field.getName().toLowerCase(Locale.ROOT);
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    BooleanOption option = (BooleanOption)field.get(null);
                    JsonPrimitive value = json.getAsJsonPrimitive(field_name);
                    if (value == null) continue;
                    option.setValue(value.getAsBoolean());
                    continue;
                }
                if (!EnumOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || (jsonPrimitive = json.getAsJsonPrimitive(field.getName().toLowerCase(Locale.ROOT))) == null || !jsonPrimitive.isString() || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                EnumOption option = (EnumOption)field.get(null);
                Enum found = null;
                ArrayList<CallSite> valid_values = new ArrayList<CallSite>();
                for (Enum value : (Enum[])((Class)generic).getEnumConstants()) {
                    String value_name = value.name().toLowerCase(Locale.ROOT);
                    valid_values.add((CallSite)((Object)("\"" + value_name + "\"")));
                    if (!value_name.equals(jsonPrimitive.getAsString())) continue;
                    found = value;
                    break;
                }
                if (found != null) {
                    ConfigStorage.setEnumRaw(option.getKey(), found);
                    continue;
                }
                InteractionManagerClient.CLIENT_LOGGER.error("Invalid option in Interaction Manager config; Path: \"{}\": \"{}\":\"{}\"; Restoring saved: \"{}\"; Valid values: {}", new Object[]{config_path, option.getKey(), jsonPrimitive.getAsString(), ((Enum)option.getValue()).name().toLowerCase(Locale.ROOT), valid_values});
                found_invalid = true;
            }
            if (found_invalid) {
                InteractionManagerConfig.saveConfig();
            }
        }
        catch (IOException | IllegalAccessException e) {
            System.err.println("Couldn't load Interaction Manager config, using defaults.");
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        InteractionManagerConfig.setupConfigFile();
        JsonObject config = new JsonObject();
        try {
            for (Field field : InteractionManagerConfig.class.getDeclaredFields()) {
                Type generic;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class)) continue;
                String field_name = field.getName().toLowerCase(Locale.ROOT);
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    BooleanOption option = (BooleanOption)field.get(null);
                    config.addProperty(field_name, Boolean.valueOf(option.getValue()));
                    continue;
                }
                if (!EnumOption.class.isAssignableFrom(field.getType()) || !(field.getGenericType() instanceof ParameterizedType) || !((generic = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class)) continue;
                EnumOption option = (EnumOption)field.get(null);
                config.addProperty(field.getName().toLowerCase(Locale.ROOT), ConfigStorage.getEnumRaw(option.getKey(), (Class)generic).name().toLowerCase(Locale.ROOT));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        String string = InteractionManager.GSON.toJson((JsonElement)config);
        try {
            BufferedWriter writer = Files.newBufferedWriter(config_path, new OpenOption[0]);
            writer.write(string);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Couldn't load Interaction Manager config, using defaults.");
            e.printStackTrace();
        }
    }

    public static void restoreDefaults() {
        try {
            for (Field field : InteractionManagerConfig.class.getDeclaredFields()) {
                IOptionConvertable option;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class) || field.isAnnotationPresent(IFileOnlyOption.class)) continue;
                if (BooleanOption.class.isAssignableFrom(field.getType())) {
                    option = (BooleanOption)field.get(null);
                    ConfigStorage.setBoolean(((BooleanOption)option).getKey(), ((BooleanOption)option).getDefaultValue());
                    continue;
                }
                if (!EnumOption.class.isAssignableFrom(field.getType())) continue;
                option = (EnumOption)field.get(null);
                ConfigStorage.setEnumRaw(((EnumOption)option).getKey(), ((EnumOption)option).getDefaultValue());
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Couldn't restore Interaction Manager config to defaults.");
            e.printStackTrace();
        }
    }

    public static boolean areOptionValuesSetToDefault() {
        try {
            for (Field field : InteractionManagerConfig.class.getDeclaredFields()) {
                IOptionConvertable option;
                if (field.isAnnotationPresent(IRuntimeInternalOnlyOption.class) || field.isAnnotationPresent(IFileOnlyOption.class) || !(BooleanOption.class.isAssignableFrom(field.getType()) ? ((BooleanOption)(option = (BooleanOption)field.get(null))).getValue() != ((BooleanOption)option).getDefaultValue() : EnumOption.class.isAssignableFrom(field.getType()) && ((EnumOption)(option = (EnumOption)field.get(null))).getValue() != ((EnumOption)option).getDefaultValue())) continue;
                return false;
            }
        }
        catch (IllegalAccessException e) {
            System.err.println("Couldn't check if Interaction Manager config is set to defaults.");
            e.printStackTrace();
        }
        return true;
    }

    public static void initRuntimeOptions() {
        IS_MODMENU_INSTALLED.setValue(FabricLoader.getInstance().getModContainer("modmenu").isPresent());
    }

    static {
        ALLOW_SHOVEL_CREATE_PATHS = new BooleanOption("allow_shovel_create_paths");
        ALLOW_AXE_STRIP_BLOCKS = new BooleanOption("allow_axe_strip_blocks");
        ALLOW_USE_FIREWORK_ON_BLOCK = new BooleanOption("allow_use_firework_on_block");
        ALLOW_ATTACKING_HOSTILE_ENTITIES = new BooleanOption("allow_attacking_hostile_entities");
        ALLOW_ATTACKING_PASSIVE_ENTITIES = new BooleanOption("allow_attacking_passive_entities");
        ALLOW_ATTACKING_VILLAGERS = new BooleanOption("allow_attacking_villagers");
        PET_ATTACK_MODE = new EnumOption<PetAttackMode>("pet_attack_mode", PetAttackMode.ALL);
        IS_MODMENU_INSTALLED = new BooleanOption("mod_menu_installed", false);
        SHOULD_ADD_INTERACTIONS_BUTTON = new EnumOption<ShouldAddInteractionsButton>("should_add_interactions_button", ShouldAddInteractionsButton.ONLY_IF_MOD_MENU_IS_NOT_INSTALLED);
    }

    public static enum PetAttackMode {
        ALL,
        ONLY_OTHER,
        NOT_TAMED,
        NONE;

    }

    public static enum ShouldAddInteractionsButton {
        ALWAYS,
        ONLY_IF_MOD_MENU_IS_NOT_INSTALLED,
        NEVER;

    }
}

