/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.client.config.option;

import com.bejker.interactionmanager.client.config.option.ConfigStorage;
import com.bejker.interactionmanager.client.config.option.IOptionConvertable;
import com.bejker.interactionmanager.util.Util;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5244;
import net.minecraft.class_7172;

public class BooleanOption
implements IOptionConvertable {
    private final String key;
    private final String translation_key;
    private final boolean default_value;
    private final class_2561 enabled_text;
    private final class_2561 disabled_text;
    private final String tooltip_key;
    private static final class_2561 OPTION_ON_TEXT = class_2561.method_43471((String)"option.interactionmanager.on");
    private static final class_2561 OPTION_OFF_TEXT = class_2561.method_43471((String)"option.interactionmanager.off");
    private static final String TRANSLATION_KEY_TYPE = "option";

    public BooleanOption(String key, boolean default_value, String enabled_key, String disabled_key) {
        this.key = key;
        this.translation_key = Util.translationKeyOf(TRANSLATION_KEY_TYPE, key);
        this.default_value = default_value;
        this.enabled_text = class_2561.method_43471((String)(this.translation_key + "." + enabled_key));
        this.disabled_text = class_2561.method_43471((String)(this.translation_key + "." + disabled_key));
        this.tooltip_key = Util.getTooltipTranslationKey(TRANSLATION_KEY_TYPE, key);
        ConfigStorage.setBoolean(key, default_value);
    }

    public BooleanOption(String key, boolean defaultValue) {
        this(key, defaultValue, "true", "false");
    }

    public BooleanOption(String key) {
        this.key = key;
        this.translation_key = Util.translationKeyOf(TRANSLATION_KEY_TYPE, key);
        this.default_value = true;
        this.enabled_text = OPTION_ON_TEXT;
        this.disabled_text = OPTION_OFF_TEXT;
        this.tooltip_key = Util.getTooltipTranslationKey(TRANSLATION_KEY_TYPE, key);
        ConfigStorage.setBoolean(key, this.default_value);
    }

    public String getKey() {
        return this.key;
    }

    public boolean getValue() {
        return ConfigStorage.getBoolean(this.key);
    }

    public void setValue(boolean value) {
        ConfigStorage.setBoolean(this.key, value);
    }

    public void toggleValue() {
        ConfigStorage.toggleBoolean(this.key);
    }

    public boolean getDefaultValue() {
        return this.default_value;
    }

    public class_2561 getButtonText() {
        return class_5244.method_32700((class_2561)class_2561.method_43471((String)this.translation_key), (class_2561)(this.getValue() ? this.enabled_text : this.disabled_text));
    }

    @Override
    public class_7172<?> asOption() {
        if (this.enabled_text == null || this.disabled_text == null) {
            return class_7172.method_41751((String)this.translation_key, (boolean)this.getValue(), value -> ConfigStorage.setBoolean(this.key, value));
        }
        return new class_7172(this.translation_key, class_2564.method_43476((class_2561)class_2561.method_43471((String)this.tooltip_key)) ? class_7172.method_42717((class_2561)class_2561.method_43471((String)this.tooltip_key)) : class_7172.method_42399(), (text, value) -> value != false ? this.enabled_text : this.disabled_text, (class_7172.class_7178)class_7172.field_38278, (Object)this.getValue(), new_value -> ConfigStorage.setBoolean(this.key, new_value));
    }
}

