/*
 * Decompiled with CFR 0.152.
 */
package com.bejker.interactionmanager.search;

import com.bejker.interactionmanager.search.Edge;
import com.bejker.interactionmanager.search.EdgeBag;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class Node {
    private int[] data;
    private int lastIdx = 0;
    private static final int START_SIZE = 0;
    private static final int INCREMENT = 1;
    private final Map<Character, Edge> edges = new EdgeBag();
    private Node suffix = null;
    private int resultCount = -1;

    Node() {
        this.data = new int[0];
    }

    Collection<Integer> getData() {
        return this.getData(-1);
    }

    Collection<Integer> getData(int numElements) {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int num : this.data) {
            ret.add(num);
            if (ret.size() != numElements) continue;
            return ret;
        }
        Object object = this.edges.values().iterator();
        while (object.hasNext()) {
            Edge e = (Edge)object.next();
            if (-1 != numElements && ret.size() >= numElements) continue;
            for (int num : e.getDest().getData()) {
                ret.add(num);
                if (ret.size() != numElements) continue;
                return ret;
            }
        }
        return ret;
    }

    void addRef(int index) {
        if (this.contains(index)) {
            return;
        }
        this.addIndex(index);
        Node iter = this.suffix;
        while (iter != null && !iter.contains(index)) {
            iter.addRef(index);
            iter = iter.suffix;
        }
    }

    private boolean contains(int index) {
        int low = 0;
        int high = this.lastIdx - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.data[mid];
            if (midVal < index) {
                low = mid + 1;
                continue;
            }
            if (midVal > index) {
                high = mid - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    protected int computeAndCacheCount() {
        this.computeAndCacheCountRecursive();
        return this.resultCount;
    }

    private Set<Integer> computeAndCacheCountRecursive() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int num : this.data) {
            ret.add(num);
        }
        Object object = this.edges.values().iterator();
        while (object.hasNext()) {
            Edge e = (Edge)object.next();
            for (int num : e.getDest().computeAndCacheCountRecursive()) {
                ret.add(num);
            }
        }
        this.resultCount = ret.size();
        return ret;
    }

    public int getResultCount() throws IllegalStateException {
        if (-1 == this.resultCount) {
            throw new IllegalStateException("getResultCount() shouldn't be called without calling computeCount() first");
        }
        return this.resultCount;
    }

    void addEdge(char ch, Edge e) {
        this.edges.put(Character.valueOf(ch), e);
    }

    Edge getEdge(char ch) {
        return this.edges.get(Character.valueOf(ch));
    }

    Map<Character, Edge> getEdges() {
        return this.edges;
    }

    Node getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node suffix) {
        this.suffix = suffix;
    }

    private void addIndex(int index) {
        if (this.lastIdx == this.data.length) {
            int[] copy = new int[this.data.length + 1];
            System.arraycopy(this.data, 0, copy, 0, this.data.length);
            this.data = copy;
        }
        this.data[this.lastIdx++] = index;
    }
}

