/*
 * Decompiled with CFR 0.152.
 */
package rearth.blocks.controller;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import rearth.Drones;
import rearth.drone.DroneData;
import rearth.drone.RecordedBlock;
import rearth.init.BlockContent;
import rearth.init.BlockEntitiesContent;
import rearth.init.ComponentContent;
import rearth.init.ItemContent;
import rearth.util.FloodFill;

public class ControllerBlockEntity
extends class_2586 {
    public static final float LOW_THRUSTER_POWER = 10.0f;
    public static final float MEDIUM_THRUSTER_POWER = 25.0f;
    public static final float HIGH_THRUSTER_POWER = 40.0f;
    public static final float ULTRA_THRUSTER_POWER = 60.0f;

    public ControllerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntitiesContent.ASSEMBLER_CONTROLLER.get(), pos, state);
    }

    public List<class_2338> getPlatformBlocks() {
        Optional<class_2338> frameStart = this.getPlatformStart();
        if (frameStart.isEmpty()) {
            return List.of();
        }
        List<class_2338> frameBlocks = FloodFill.Run(this.field_11863, frameStart.get(), candidate -> candidate.method_53257(BlockContent.ASSEMBLER_FRAME), checkPos -> true, 200, false);
        if (frameBlocks.isEmpty()) {
            return List.of();
        }
        return frameBlocks;
    }

    @Nullable
    public DroneData getCurrentDroneData() {
        List<class_2338> frameBlocks = this.getPlatformBlocks();
        if (frameBlocks.isEmpty()) {
            return null;
        }
        class_2338 droneStart = null;
        for (class_2338 frameBlock : frameBlocks) {
            class_2338 frameAbove = frameBlock.method_10084();
            class_2680 candidateState = this.field_11863.method_8320(frameAbove);
            if (!ControllerBlockEntity.isValidDroneBlock(candidateState)) continue;
            droneStart = frameAbove;
            break;
        }
        if (droneStart == null) {
            return null;
        }
        List<class_2338> droneBlocks = FloodFill.Run(this.field_11863, droneStart, ControllerBlockEntity::isValidDroneBlock, this::isAboveOwnFrame, 1000, true);
        class_2338 droneCenter = ControllerBlockEntity.findCenterOfMass(droneBlocks);
        System.out.println("drone: " + String.valueOf(droneBlocks));
        ArrayList<RecordedBlock> blockData = new ArrayList<RecordedBlock>();
        for (class_2338 blockPos : droneBlocks) {
            class_2680 blockState = this.field_11863.method_8320(blockPos);
            class_2338 localPos = blockPos.method_10059((class_2382)droneCenter);
            RecordedBlock data = new RecordedBlock(blockState, (class_2382)localPos);
            blockData.add(data);
        }
        int droneId = this.field_11863.method_8409().method_43048(Integer.MAX_VALUE);
        class_2338 droneOffset = droneCenter.method_10059((class_2382)this.field_11867);
        return new DroneData(blockData, droneId, (class_2382)droneOffset);
    }

    private boolean isAboveOwnFrame(class_2338 pos) {
        int maxRange = 20;
        for (int i = 1; i <= maxRange; ++i) {
            class_2338 testPos = pos.method_10087(i);
            if (!this.field_11863.method_8320(testPos).method_53257(BlockContent.ASSEMBLER_FRAME)) continue;
            return true;
        }
        return false;
    }

    private static class_2338 findCenterOfMass(List<class_2338> positions) {
        if (positions.isEmpty()) {
            Drones.LOGGER.warn("tried to find COM for empty drone");
            return class_2338.field_10980;
        }
        double dataX = 0.0;
        double dataY = 0.0;
        double dataZ = 0.0;
        for (class_2338 pos : positions) {
            class_243 center = pos.method_46558();
            dataX += center.field_1352;
            dataY += center.field_1351;
            dataZ += center.field_1350;
        }
        class_243 realCOM = new class_243(dataX / (double)positions.size(), dataY / (double)positions.size(), dataZ / (double)positions.size());
        return class_2338.method_49638((class_2374)realCOM);
    }

    private Optional<class_2338> getPlatformStart() {
        for (class_2338 neighbor : FloodFill.GetHorizontalNeighbors(this.field_11867)) {
            if (!this.field_11863.method_8320(neighbor).method_53257(BlockContent.ASSEMBLER_FRAME)) continue;
            return Optional.of(neighbor);
        }
        return Optional.empty();
    }

    public boolean loadDroneToWorld(DroneData data) {
        class_2338 worldPos;
        class_2382 offset;
        if (this.getCurrentDroneData() != null) {
            return false;
        }
        for (RecordedBlock droneBlockData : data.getBlocks()) {
            offset = droneBlockData.localPos();
            worldPos = this.field_11867.method_10081(data.getAssemblerOffset()).method_10081(offset);
            if (!this.isAboveOwnFrame(worldPos)) {
                return false;
            }
            class_2680 worldState = this.field_11863.method_8320(worldPos);
            if (worldState.method_26215()) continue;
            return false;
        }
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_21933, class_3419.field_15245, 1.0f, 1.0f);
        for (RecordedBlock droneBlockData : data.getBlocks()) {
            offset = droneBlockData.localPos();
            worldPos = this.field_11867.method_10081(data.getAssemblerOffset()).method_10081(offset);
            this.field_11863.method_8501(worldPos, droneBlockData.state());
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 spawnAt = worldPos.method_46558();
            serverWorld.method_14199((class_2394)class_2398.field_47494, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, 1, 0.0, (double)0.1f, 0.0, 0.5);
        }
        return true;
    }

    private static boolean isValidDroneBlock(class_2680 state) {
        return !state.method_26215() && !state.method_51176() && !state.method_53257(BlockContent.ASSEMBLER_FRAME) && !state.method_53257(BlockContent.ASSEMBLER_CONTROLLER);
    }

    public void assembleDrone(class_1657 player, String name) {
        Drones.LOGGER.info("Assembling drone for: {}, drone name: {}", (Object)player.method_5477(), (Object)name);
        DroneData droneData = this.getCurrentDroneData();
        if (droneData == null) {
            Drones.LOGGER.warn("Player tried to create empty/invalid drone");
            return;
        }
        class_1799 createdStack = new class_1799(ItemContent.POCKET_DRONE);
        createdStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)name));
        createdStack.method_57379((class_9331)ComponentContent.DRONE_DATA_TYPE.get(), (Object)droneData);
        class_1542 itemEntity = new class_1542(this.field_11863, player.method_23317(), player.method_23318(), player.method_23321(), createdStack);
        this.field_11863.method_8649((class_1297)itemEntity);
        for (RecordedBlock droneBlock : droneData.getBlocks()) {
            class_2338 worldPos = this.field_11867.method_10081(droneData.getAssemblerOffset()).method_10081(droneBlock.localPos());
            this.field_11863.method_8501(worldPos, class_2246.field_10124.method_9564());
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 spawnAt = worldPos.method_46558();
            serverWorld.method_14199((class_2394)class_2398.field_47494, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, 1, 0.0, (double)0.1f, 0.0, 0.5);
        }
    }

    public record AssembleDronePacket(String name, class_2338 controllerPos) implements class_8710
    {
        public static final class_8710.class_9154<AssembleDronePacket> PAYLOAD_ID = new class_8710.class_9154(Drones.id("assemble"));
        public static final class_9139<ByteBuf, AssembleDronePacket> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, AssembleDronePacket::name, (class_9139)class_2338.field_48404, AssembleDronePacket::controllerPos, AssembleDronePacket::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PAYLOAD_ID;
        }
    }
}

