/*
 * Decompiled with CFR 0.152.
 */
package rearth.client.renderers;

import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import rearth.DronesClient;
import rearth.drone.DroneController;
import rearth.drone.DroneData;
import rearth.drone.RecordedBlock;
import rearth.init.NetworkContent;
import rearth.util.FloodFill;
import rearth.util.Helpers;

public class DroneRenderer {
    private static final HashMap<class_1657, class_243> lastPositions = new HashMap();
    private static final HashMap<class_1657, class_243> lastRotations = new HashMap();

    public static void doRender(class_4587 matrices, class_4184 camera, class_4597 vertexConsumers) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        for (class_742 dronePlayer : world.method_18456()) {
            Optional<DroneData> droneCandidate = DroneController.getDroneOfPlayer((class_1657)dronePlayer);
            if (droneCandidate.isEmpty()) continue;
            DroneData droneData = droneCandidate.get();
            NetworkContent.DroneMoveSyncPacket movementData = DronesClient.CURRENT_DATA.get(droneData.getDroneId());
            if (movementData == null) {
                return;
            }
            float tickDelta = class_310.method_1551().method_60646().method_60637(false);
            float targetScale = 0.15f * droneData.getRenderScale();
            class_243 lastPos = lastPositions.computeIfAbsent((class_1657)dronePlayer, player -> movementData.position());
            class_243 lastRot = lastRotations.computeIfAbsent((class_1657)dronePlayer, player -> movementData.rotation());
            class_243 newPos = movementData.position();
            class_243 newRot = movementData.rotation();
            double rotDistY = Math.abs(lastRot.field_1351 - newRot.field_1351);
            double altRotDistY = Math.abs(-lastRot.field_1351 - newRot.field_1351);
            if (altRotDistY < rotDistY && Math.abs(lastRot.field_1351) > 90.0) {
                boolean positive = lastRot.field_1351 > 0.0;
                double adjustedY = positive ? lastRot.field_1351 - 360.0 : lastRot.field_1351 + 360.0;
                lastRot = new class_243(lastRot.field_1352, adjustedY, lastRot.field_1350);
            }
            class_243 deltaDronePos = Helpers.lerp(lastPos, newPos, 0.1f);
            lastPositions.put((class_1657)dronePlayer, deltaDronePos);
            class_243 deltaDroneRot = Helpers.lerp(lastRot, newRot, 0.02f);
            lastRotations.put((class_1657)dronePlayer, deltaDroneRot);
            matrices.method_22903();
            matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
            matrices.method_22904(deltaDronePos.field_1352, deltaDronePos.field_1351, deltaDronePos.field_1350);
            matrices.method_22907(class_7833.field_40714.rotationDegrees((float)(-deltaDroneRot.field_1352)));
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)(-deltaDroneRot.field_1350)));
            matrices.method_22907(class_7833.field_40716.rotationDegrees((float)(-deltaDroneRot.field_1351)));
            for (RecordedBlock blockData : droneData.getBlocks()) {
                class_2382 localOffset = blockData.localPos();
                class_2680 state = blockData.state();
                class_243 scaledLocalOffset = class_243.method_24954((class_2382)localOffset).method_1031(-0.5, -0.5, -0.5).method_1021((double)targetScale);
                matrices.method_22903();
                matrices.method_22904(scaledLocalOffset.field_1352, scaledLocalOffset.field_1351, scaledLocalOffset.field_1350);
                matrices.method_22905(targetScale, targetScale, targetScale);
                int light = DroneRenderer.getMaxLight(class_2338.method_49638((class_2374)movementData.position()), (class_1937)world);
                class_310.method_1551().method_1541().method_3353(state, matrices, vertexConsumers, light, class_4608.field_21444);
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof class_2343) {
                    class_2343 blockEntityProvider = (class_2343)class_22482;
                    class_2586 blockEntity = blockEntityProvider.method_10123(new class_2338(localOffset), state);
                    blockEntity.method_31662((class_1937)world);
                    class_827 renderer = class_310.method_1551().method_31975().method_3550(blockEntity);
                    if (renderer != null) {
                        renderer.method_3569(blockEntity, 0.0f, matrices, vertexConsumers, light, class_4608.field_21444);
                    }
                }
                matrices.method_22909();
            }
            matrices.method_22909();
        }
    }

    private static int getMaxLight(class_2338 center, class_1937 world) {
        int bestLight = class_761.method_23794((class_1920)world, (class_2338)center);
        for (class_2338 side : FloodFill.GetNeighbors(center)) {
            int candidate = class_761.method_23794((class_1920)world, (class_2338)side);
            bestLight = Math.max(candidate, bestLight);
        }
        return bestLight;
    }
}

