/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone;

import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.wispforest.accessories.api.AccessoriesContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3541;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import rearth.drone.DroneData;
import rearth.drone.DroneServerData;
import rearth.drone.behaviour.BeamAttackBehaviour;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneLight;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.MeleeAttackBehaviour;
import rearth.drone.behaviour.MiningSupportBehaviour;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.ComponentContent;
import rearth.init.ItemContent;
import rearth.init.NetworkContent;
import rearth.util.Helpers;

public class DroneController {
    public static final int SNAP_RANGE = 30;
    private static final HashMap<Integer, DroneServerData> WORK_DATA = new HashMap();
    public static final class_3541 SIMPLEX = new class_3541(class_5819.method_43047());

    public static void tickPlayer(class_3222 playerEntity) {
        Optional<DroneServerData> droneCandidate = DroneController.getPlayerServerData((class_1657)playerEntity);
        droneCandidate.ifPresent(serverData -> DroneController.updateDrone((class_1657)playerEntity, serverData));
    }

    public static void updateDrone(class_1657 player, DroneServerData serverData) {
        if (serverData.getCurrentTask() == null) {
            serverData.setCurrentTask(new PlayerSwarmBehaviour(serverData, player));
        }
        if (serverData.droneData.isGlowing()) {
            DroneLight.updateDroneLight(serverData, player.method_37908());
        }
        DroneController.updateDroneSensors(player, serverData);
        serverData.getCurrentTask().tick();
        DroneController.updateDroneMovement(player, serverData);
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            List nearbyPlayers = serverWorld.method_18766(candidate -> candidate.method_19538().method_1025(player.method_19538()) < 10000.0);
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (class_8710)new NetworkContent.DroneMoveSyncPacket(serverData.currentPosition, serverData.currentRotation, serverData.droneData.getDroneId()));
        }
    }

    private static void updateDroneSensors(class_1657 player, DroneServerData serverData) {
        int currentPriority = serverData.getCurrentTask().getPriority();
        for (DroneSensor sensor : serverData.droneData.enabledSensors) {
            if (currentPriority >= sensor.getPriority() || sensor.sense(serverData, player)) break;
        }
    }

    private static void updateDroneMovement(class_1657 player, DroneServerData serverData) {
        boolean positionBlocked;
        class_1937 class_19372;
        float powerMultiplier = serverData.droneData.power;
        float accelerationPower = 0.2f;
        double bankingFactor = 30.0 * Math.sqrt(powerMultiplier);
        class_243 currentVelocity = serverData.currentVelocity;
        class_243 targetOffset = serverData.targetPosition.method_1020(serverData.currentPosition);
        class_243 velocityDelta = targetOffset.method_1020(currentVelocity);
        double rotationAngle = serverData.currentRotation.field_1351;
        double bankX = Math.clamp(velocityDelta.field_1350 * -bankingFactor, -45.0, 45.0);
        double bankZ = Math.clamp(velocityDelta.field_1352 * bankingFactor, -45.0, 45.0);
        double acceleration = velocityDelta.method_1033();
        double spawnChance = acceleration - 0.5;
        if ((double)player.method_37908().method_8409().method_43057() < spawnChance && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)class_2398.field_50252, serverData.currentPosition.field_1352, serverData.currentPosition.field_1351 - (double)0.2f, serverData.currentPosition.field_1350, 1, (double)0.1f, 0.1, 0.1, (double)0.1f);
        }
        if (serverData.getCurrentTask() != null) {
            rotationAngle = serverData.getCurrentTask().getCurrentYaw();
            bankX += (double)serverData.getCurrentTask().getExtraRoll();
        }
        serverData.currentRotation = new class_243(bankX, rotationAngle, bankZ);
        serverData.currentVelocity = currentVelocity.method_1019(velocityDelta.method_1021((double)accelerationPower));
        class_243 nextPosition = serverData.currentPosition.method_1019(serverData.currentVelocity.method_1021((double)(powerMultiplier / 20.0f)));
        boolean bl = positionBlocked = !Helpers.isLineAvailable(player.method_37908(), serverData.currentPosition, nextPosition);
        if (serverData.ghostTicks > 0) {
            --serverData.ghostTicks;
            serverData.currentPosition = nextPosition;
        } else if (serverData.ghostWaitTime > 0) {
            --serverData.ghostWaitTime;
            if (serverData.ghostWaitTime == 0) {
                serverData.ghostTicks = 20;
            }
        } else if (positionBlocked) {
            serverData.currentVelocity = class_243.field_1353;
            serverData.ghostWaitTime = 14;
            class_1937 class_19373 = player.method_37908();
            if (class_19373 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19373;
                class_243 middle = serverData.currentPosition;
                serverWorld.method_14199((class_2394)class_2398.field_11214, middle.field_1352, middle.field_1351, middle.field_1350, 15, 0.0, 0.0, 0.0, (double)0.2f);
            }
        } else {
            serverData.currentPosition = nextPosition;
            serverData.ghostTicks = 0;
            serverData.ghostWaitTime = 0;
        }
        double playerDist = serverData.currentPosition.method_1022(player.method_33571());
        if (playerDist > 30.0) {
            serverData.currentPosition = player.method_33571();
        }
    }

    public static Optional<DroneServerData> getPlayerServerData(class_1657 playerEntity) {
        Optional<DroneData> droneCandidate = DroneController.getDroneOfPlayer(playerEntity);
        if (playerEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)playerEntity;
            if (droneCandidate.isPresent()) {
                DroneServerData serverData = WORK_DATA.computeIfAbsent(droneCandidate.get().getDroneId(), droneId -> new DroneServerData((DroneData)droneCandidate.get(), serverPlayer));
                return Optional.of(serverData);
            }
        }
        return Optional.empty();
    }

    public static Optional<DroneData> getDroneOfPlayer(class_1657 playerEntity) {
        class_1799 droneCandidate = playerEntity.method_6118(class_1304.field_6169);
        if (droneCandidate.method_31574((class_1792)ItemContent.POCKET_DRONE.get()) && droneCandidate.method_57826((class_9331)ComponentContent.DRONE_DATA_TYPE.get())) {
            DroneData droneData = (DroneData)droneCandidate.method_57824((class_9331)ComponentContent.DRONE_DATA_TYPE.get());
            if (droneData == null) {
                return Optional.empty();
            }
            return Optional.of(droneData);
        }
        if (Platform.isModLoaded((String)"accessories") && playerEntity.accessoriesCapability() != null && playerEntity.accessoriesCapability().getContainers() != null) {
            AccessoriesContainer headCosmetic = (AccessoriesContainer)playerEntity.accessoriesCapability().getContainers().get("accessories:head");
            if (headCosmetic == null) {
                return Optional.empty();
            }
            for (Pair pair : headCosmetic.getCosmeticAccessories()) {
                class_1799 candidate = (class_1799)pair.getSecond();
                if (!candidate.method_31574((class_1792)ItemContent.POCKET_DRONE.get()) || !candidate.method_57826((class_9331)ComponentContent.DRONE_DATA_TYPE.get())) continue;
                DroneData droneData = (DroneData)candidate.method_57824((class_9331)ComponentContent.DRONE_DATA_TYPE.get());
                if (droneData == null) {
                    return Optional.empty();
                }
                return Optional.of(droneData);
            }
        }
        return Optional.empty();
    }

    private static void issueAttackCommend(class_1657 player, DroneServerData serverData, class_1309 livingEntity) {
        if (serverData.droneData.installed.contains((Object)DroneBehaviour.BlockFunctions.BEAM)) {
            serverData.setCurrentTask(new BeamAttackBehaviour(livingEntity, player, serverData));
            return;
        }
        if (serverData.droneData.installed.contains((Object)DroneBehaviour.BlockFunctions.MELEE_ATTACK)) {
            serverData.setCurrentTask(new MeleeAttackBehaviour(livingEntity, player, serverData));
        }
    }

    public static EventResult onPlayerAttackEntityEvent(class_1657 player, class_1937 world, class_1297 entity, class_1268 hand, @Nullable class_3966 entityHitResult) {
        Optional<DroneServerData> droneCandidate = DroneController.getPlayerServerData(player);
        if (droneCandidate.isPresent() && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            DroneController.issueAttackCommend(player, droneCandidate.get(), livingEntity);
        }
        return EventResult.pass();
    }

    public static void onPlayerBlockBreakStart(class_1657 player, class_2338 blockPos) {
        Optional<DroneServerData> droneCandidate = DroneController.getPlayerServerData(player);
        if (droneCandidate.isPresent() && MiningSupportBehaviour.isValidMiningTarget(player.method_37908(), blockPos) && droneCandidate.get().droneData.installed.contains((Object)DroneBehaviour.BlockFunctions.MINING_SUPPORT)) {
            droneCandidate.get().setCurrentTask(new MiningSupportBehaviour(blockPos, player, droneCandidate.get()));
        }
    }
}

