/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class ArrowAttackBehaviour
extends PlayerSwarmBehaviour {
    private static final int MAX_RANGE = 25;
    public final class_1309 target;
    public final class_1657 owner;
    public final DroneServerData drone;
    private int attackCooldown = 0;

    public ArrowAttackBehaviour(class_1309 target, class_1657 owner, DroneServerData drone) {
        super(drone, owner);
        this.target = target;
        this.owner = owner;
        this.drone = drone;
    }

    @Override
    public void tick() {
        class_243 shotFrom;
        double dist;
        super.tick();
        if (this.target.method_31481() || !this.target.method_5805() || !this.target.method_5732()) {
            this.finishTask();
        }
        if ((dist = (shotFrom = this.owner.method_33571().method_1031(0.0, 1.2, 0.0)).method_1022(this.target.method_33571())) > 25.0) {
            this.finishTask();
        }
        if (this.attackCooldown <= 0) {
            this.attackCooldown = this.getAttackCooldown();
            this.performAttack(dist, shotFrom);
        } else {
            --this.attackCooldown;
        }
    }

    public void performAttack(double dist, class_243 shotFrom) {
        class_1937 world = this.owner.method_37908();
        class_1799 stack = new class_1799((class_1935)class_1802.field_8107);
        class_243 targetPos = this.target.method_33571().method_1031(0.0, dist / 10.0, 0.0);
        class_243 offset = targetPos.method_1020(shotFrom);
        class_243 initialVelocity = offset.method_1029().method_1021(2.0);
        class_1667 arrowEntity = new class_1667(world, shotFrom.field_1352, shotFrom.field_1351, shotFrom.field_1350, stack, null);
        arrowEntity.method_18799(initialVelocity);
        world.method_8649((class_1297)arrowEntity);
        class_1937 class_19372 = this.owner.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 forward = this.target.method_33571().method_1020(this.drone.currentPosition).method_1029();
            class_243 particleStart = this.drone.currentPosition.method_1019(forward.method_1021((double)0.3f));
            serverWorld.method_14199((class_2394)class_2398.field_50252, particleStart.field_1352, particleStart.field_1351, particleStart.field_1350, 1, forward.field_1352, forward.field_1351, forward.field_1350, (double)0.2f);
        }
    }

    public int getAttackCooldown() {
        return 24;
    }

    public void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public float getCurrentYaw() {
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.method_33571());
    }

    @Override
    public int getPriority() {
        return 55;
    }

    public static boolean isValid(RecordedBlock block, HashMap<class_2382, class_2680> frame) {
        boolean blockMatches = block.state().method_26164(TagContent.ARROW_LAUNCHER);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().method_35858(i))) continue;
            return false;
        }
        return true;
    }

    public static class ArrowAttackSensor
    implements DroneSensor {
        @Override
        public int getPriority() {
            return 35;
        }

        @Override
        public boolean sense(DroneServerData drone, class_1657 player) {
            class_1937 world = player.method_37908();
            int entityRange = this.getTargetingRange();
            class_243 playerHead = player.method_33571();
            List<class_1309> targets = world.method_8390(class_1309.class, new class_238(playerHead.field_1352 - (double)entityRange, playerHead.field_1351 - (double)entityRange, playerHead.field_1350 - (double)entityRange, playerHead.field_1352 + (double)entityRange, playerHead.field_1351 + (double)entityRange, playerHead.field_1350 + (double)entityRange), class_1301.field_6157.and(class_1301.field_6156));
            targets.sort(Comparator.comparingDouble(entity -> entity.method_5707(playerHead)));
            targets = targets.stream().filter(target -> target.method_5805() && !target.method_31481() && target instanceof class_1569).toList();
            if (!targets.isEmpty()) {
                this.onTargetFound(drone, player, targets.getFirst());
                return true;
            }
            return false;
        }

        public int getTargetingRange() {
            return 16;
        }

        public void onTargetFound(DroneServerData drone, class_1657 player, class_1309 target) {
            drone.setCurrentTask(new ArrowAttackBehaviour(target, player, drone));
        }
    }
}

