/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.ArrowAttackBehaviour;
import rearth.init.TagContent;

public class BeamAttackBehaviour
extends ArrowAttackBehaviour {
    private static final int ATTACK_DAMAGE = 10;

    public BeamAttackBehaviour(class_1309 target, class_1657 owner, DroneServerData drone) {
        super(target, owner, drone);
    }

    @Override
    public void performAttack(double dist, class_243 shotFrom) {
        class_1937 world = this.owner.method_37908();
        this.target.method_5643(new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42320)), 10.0f);
        world.method_8396(null, this.owner.method_24515(), class_3417.field_38830, class_3419.field_15248, 0.5f, 1.7f);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.spawnBeamLine(this.drone.currentPosition, this.target.method_33571(), serverWorld);
        }
    }

    private void spawnBeamLine(class_243 from, class_243 to, class_3218 world) {
        int count = (int)(from.method_1022(to) * (double)0.6f + 1.0);
        count = Math.min(count, 12);
        class_243 increment = to.method_1020(from).method_1021((double)(1.0f / (float)count));
        class_2400 particle = class_2398.field_38908;
        world.method_14199((class_2394)class_2398.field_11236, to.field_1352, to.field_1351, to.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        int finalCount = count;
        CompletableFuture.runAsync(() -> {
            for (int i = 0; i < finalCount; ++i) {
                class_243 pos = from.method_1019(increment.method_1021((double)i));
                world.method_14199((class_2394)particle, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        });
    }

    @Override
    public int getAttackCooldown() {
        return 30;
    }

    public static boolean isValid(RecordedBlock block, HashMap<class_2382, class_2680> frame) {
        boolean blockMatches = block.state().method_26164(TagContent.BEAM_SOURCE);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().method_35858(i))) continue;
            return false;
        }
        return true;
    }

    public static class BeamAttackSensor
    extends ArrowAttackBehaviour.ArrowAttackSensor {
        @Override
        public int getPriority() {
            return super.getPriority() + 2;
        }

        @Override
        public int getTargetingRange() {
            return super.getTargetingRange() + 8;
        }

        @Override
        public void onTargetFound(DroneServerData drone, class_1657 player, class_1309 target) {
            drone.setCurrentTask(new BeamAttackBehaviour(target, player, drone));
        }
    }
}

