/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.HashMap;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import rearth.Drones;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class MiningSupportBehaviour
implements DroneBehaviour {
    private static final int MAX_RANGE = 10;
    private static final float REACH = 0.6f;
    private static final int WAIT_TIME = 14;
    private final class_2338 target;
    private final class_1657 owner;
    private final DroneServerData drone;
    private final class_2680 startState;
    private SupportPhase phase;
    private int waitTicks;

    public MiningSupportBehaviour(class_2338 target, class_1657 owner, DroneServerData drone) {
        this.target = target;
        this.owner = owner;
        this.drone = drone;
        this.phase = SupportPhase.MOVING_IN;
        this.startState = owner.method_37908().method_8320(target);
    }

    @Override
    public void tick() {
        if (!this.phase.equals((Object)SupportPhase.WAITING)) {
            if (!this.owner.method_37908().method_8320(this.target).equals(this.startState)) {
                this.finishMining();
                return;
            }
            class_1657 class_16572 = this.owner;
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                class_2338 currentlyMiningPos = serverPlayer.field_13974.field_20327;
                boolean stillMining = serverPlayer.field_13974.field_14003;
                if (!currentlyMiningPos.equals((Object)this.target) || !stillMining) {
                    this.finishMining();
                    return;
                }
            }
        }
        switch (this.phase.ordinal()) {
            case 0: {
                this.drone.targetPosition = this.getTargetPosition();
                double ownerDist = this.owner.method_33571().method_1022(this.drone.currentPosition);
                if (ownerDist > 10.0) {
                    this.finishTask();
                    return;
                }
                double targetDist = this.drone.currentPosition.method_1022(this.drone.targetPosition);
                if (!(targetDist < (double)0.6f)) break;
                this.phase = SupportPhase.SUPPORTING;
                class_1324 miningInstance = this.owner.method_5996(class_5134.field_49076);
                if (miningInstance == null || miningInstance.method_6196(Drones.id("drone_mine_bonus"))) break;
                miningInstance.method_26835(new class_1322(Drones.id("drone_mine_bonus"), 5.0, class_1322.class_1323.field_6328));
                break;
            }
            case 1: {
                this.drone.targetPosition = this.getTargetPosition();
                double ownerDist = this.owner.method_33571().method_1022(this.drone.currentPosition);
                if (!(ownerDist > 10.0)) break;
                this.finishTask();
                break;
            }
            case 2: {
                --this.waitTicks;
                if (this.waitTicks > 0) break;
                this.finishTask();
            }
        }
    }

    private void finishMining() {
        this.phase = SupportPhase.WAITING;
        this.waitTicks = 14;
    }

    @Override
    public float getExtraRoll() {
        if (this.phase == SupportPhase.SUPPORTING) {
            long time = this.owner.method_37908().method_8510();
            return (float)(Math.sin((float)time / 2.0f) * 20.0);
        }
        return DroneBehaviour.super.getExtraRoll();
    }

    @Override
    public void onStopped() {
        Drones.DELAYED_ACTIONS.add(() -> {
            class_1324 miningInstance = this.owner.method_5996(class_5134.field_49076);
            if (miningInstance != null) {
                miningInstance.method_6200(Drones.id("drone_mine_bonus"));
            }
        });
    }

    public void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public float getCurrentYaw() {
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.method_46558());
    }

    @Override
    public int getPriority() {
        return this.phase == SupportPhase.WAITING ? 3 : 20;
    }

    private class_243 getTargetPosition() {
        class_243 playerPos = this.owner.method_33571();
        class_243 blockCenter = this.target.method_46558();
        class_243 playerDir = blockCenter.method_1020(playerPos).method_1029();
        class_243 playerUp = new class_243(0.0, 1.0, 0.0);
        class_243 sideDirection = playerDir.method_1036(playerUp);
        class_243 otherSideDirection = sideDirection.method_1021(-1.0);
        class_243 potentialPosA = blockCenter.method_1019(sideDirection).method_1019(playerDir.method_1021(-1.0));
        class_243 potentialPosB = blockCenter.method_1019(otherSideDirection).method_1019(playerDir.method_1021(-1.0));
        class_243 potentialPosC = blockCenter.method_1019(playerDir.method_1021(-2.0)).method_1031(0.0, -0.6, 0.0);
        if (Helpers.isPositionAvailable(this.owner.method_37908(), potentialPosA, playerPos)) {
            return potentialPosA;
        }
        if (Helpers.isPositionAvailable(this.owner.method_37908(), potentialPosB, playerPos)) {
            return potentialPosB;
        }
        return potentialPosC;
    }

    public static boolean isValidMiningTarget(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return !state.method_26215() && !state.method_51176() && state.method_26214((class_1922)world, pos) > 0.1f;
    }

    public static boolean isValid(RecordedBlock block, HashMap<class_2382, class_2680> frame) {
        boolean blockMatches = block.state().method_26164(TagContent.MINING_TOOLS);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().method_35858(i))) continue;
            return false;
        }
        return true;
    }

    private static enum SupportPhase {
        MOVING_IN,
        SUPPORTING,
        WAITING;

    }
}

