/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class PickupBehaviour
implements DroneBehaviour {
    private static final int MAX_RANGE = 25;
    private static final float PICKUP_RANGE = 0.75f;
    private final class_1657 owner;
    private final DroneServerData drone;
    private final class_1542 target;
    private PickupPhase phase;
    private boolean collected = false;

    public PickupBehaviour(class_1657 owner, DroneServerData drone, class_1542 target) {
        this.owner = owner;
        this.drone = drone;
        this.target = target;
        this.phase = PickupPhase.MOVING_IN;
    }

    @Override
    public void tick() {
        switch (this.phase.ordinal()) {
            case 0: {
                this.drone.targetPosition = this.target.method_33571();
                double playerDist = this.drone.currentPosition.method_1022(this.owner.method_33571());
                double targetDist = this.drone.currentPosition.method_1022(this.target.method_33571());
                if (playerDist > 25.0 || this.target.method_31481()) {
                    this.phase = PickupPhase.MOVING_HOME;
                }
                if (!(targetDist < 0.75)) break;
                this.phase = PickupPhase.MOVING_HOME;
                this.collected = true;
                this.target.method_5875(true);
                break;
            }
            case 1: {
                double playerDist;
                this.drone.targetPosition = this.owner.method_33571().method_1031(0.0, 0.7, 0.0);
                if (this.collected && !this.target.method_31481()) {
                    this.target.method_33574(this.drone.currentPosition);
                }
                if (!((playerDist = this.drone.currentPosition.method_1022(this.owner.method_33571())) < 1.0)) break;
                this.finishTask();
            }
        }
    }

    private void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public void onStopped() {
        if (this.collected && !this.target.method_31481()) {
            this.target.method_5875(true);
        }
    }

    @Override
    public float getCurrentYaw() {
        if (this.phase == PickupPhase.MOVING_HOME) {
            return Helpers.calculateYaw(this.drone.currentPosition, this.owner.method_33571());
        }
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.method_33571());
    }

    @Override
    public int getPriority() {
        return 10;
    }

    public static Optional<class_1542> GetPickupTarget(class_1657 player) {
        class_1937 world = player.method_37908();
        class_243 target = player.method_33571();
        int range = 12;
        class_238 box = new class_238(target.field_1352 - (double)range, target.field_1351 - (double)range, target.field_1350 - (double)range, target.field_1352 + (double)range, target.field_1351 + (double)range, target.field_1350 + (double)range);
        List items = world.method_8390(class_1542.class, box, itemEntity -> !itemEntity.method_6977());
        if (!items.isEmpty()) {
            return Optional.of((class_1542)items.getFirst());
        }
        return Optional.empty();
    }

    public static boolean isValid(RecordedBlock block, HashMap<class_2382, class_2680> frame) {
        boolean blockMatches = block.state().method_26164(TagContent.PICKUP_TOOLS);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().method_23227(i))) continue;
            return false;
        }
        return true;
    }

    private static enum PickupPhase {
        MOVING_IN,
        MOVING_HOME;

    }

    public static class PickupSensor
    implements DroneSensor {
        @Override
        public int getPriority() {
            return 10;
        }

        @Override
        public boolean sense(DroneServerData drone, class_1657 player) {
            Optional<class_1542> candidate = PickupBehaviour.GetPickupTarget(player);
            if (candidate.isPresent()) {
                drone.setCurrentTask(new PickupBehaviour(player, drone, candidate.get()));
                return true;
            }
            return false;
        }
    }
}

