/*
 * Decompiled with CFR 0.152.
 */
package rearth.init;

import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import rearth.Drones;
import rearth.DronesClient;
import rearth.blocks.controller.ControllerBlockEntity;
import rearth.init.BlockEntitiesContent;
import rearth.util.Helpers;

public class NetworkContent {
    public static void init() {
        NetworkContent.registerS2C(DroneMoveSyncPacket.PAYLOAD_ID, DroneMoveSyncPacket.PACKET_CODEC, (value, context) -> DronesClient.CURRENT_DATA.put(value.droneId(), (DroneMoveSyncPacket)value));
        if (Platform.getEnvironment().equals((Object)Env.SERVER)) {
            NetworkAggregator.registerS2CType(OpenDroneScreenPacket.PAYLOAD_ID, OpenDroneScreenPacket.PACKET_CODEC, List.of());
        }
        NetworkContent.registerC2S(ControllerBlockEntity.AssembleDronePacket.PAYLOAD_ID, ControllerBlockEntity.AssembleDronePacket.PACKET_CODEC, (value, context) -> {
            class_1937 world = context.getPlayer().method_37908();
            class_1657 player = context.getPlayer();
            Optional candidate = world.method_35230(value.controllerPos(), (class_2591)BlockEntitiesContent.ASSEMBLER_CONTROLLER.get());
            candidate.ifPresent(controllerBlockEntity -> controllerBlockEntity.assembleDrone(player, value.name()));
        });
    }

    private static <T extends class_8710> void registerS2C(class_8710.class_9154<T> dataPayloadId, class_9139<ByteBuf, T> packetCodec, NetworkManager.NetworkReceiver<T> receiver) {
        if (Platform.getEnvironment().equals((Object)Env.SERVER)) {
            NetworkAggregator.registerS2CType(dataPayloadId, packetCodec, List.of());
        } else {
            NetworkAggregator.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, dataPayloadId, packetCodec, List.of(), receiver);
        }
    }

    private static <T extends class_8710> void registerC2S(class_8710.class_9154<T> dataPayloadId, class_9139<ByteBuf, T> packetCodec, NetworkManager.NetworkReceiver<T> receiver) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, dataPayloadId, packetCodec, receiver);
    }

    public record DroneMoveSyncPacket(class_243 position, class_243 rotation, int droneId) implements class_8710
    {
        public static final class_8710.class_9154<DroneMoveSyncPacket> PAYLOAD_ID = new class_8710.class_9154(Drones.id("move"));
        public static final class_9139<ByteBuf, DroneMoveSyncPacket> PACKET_CODEC = class_9139.method_56436(Helpers.VEC3D_PACKET_CODEC, DroneMoveSyncPacket::position, Helpers.VEC3D_PACKET_CODEC, DroneMoveSyncPacket::rotation, (class_9139)class_9135.field_49675, DroneMoveSyncPacket::droneId, DroneMoveSyncPacket::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PAYLOAD_ID;
        }
    }

    public record OpenDroneScreenPacket(class_2338 controllerPos) implements class_8710
    {
        public static final class_8710.class_9154<OpenDroneScreenPacket> PAYLOAD_ID = new class_8710.class_9154(Drones.id("open_screen"));
        public static final class_9139<ByteBuf, OpenDroneScreenPacket> PACKET_CODEC = class_9139.method_56434((class_9139)class_2338.field_48404, OpenDroneScreenPacket::controllerPos, OpenDroneScreenPacket::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PAYLOAD_ID;
        }
    }
}

