/*
 * Decompiled with CFR 0.152.
 */
package rearth;

import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rearth.drone.DroneController;
import rearth.drone.behaviour.DroneLight;
import rearth.init.BlockContent;
import rearth.init.BlockEntitiesContent;
import rearth.init.ComponentContent;
import rearth.init.ItemContent;
import rearth.init.ItemGroups;
import rearth.init.NetworkContent;

public final class Drones {
    public static final String MOD_ID = "drones";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"drones");
    public static final List<Runnable> DELAYED_ACTIONS = new ArrayList<Runnable>();

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void init() {
        LOGGER.info("May your drones assemble without issue!");
        BlockContent.BLOCKS.register();
        BlockEntitiesContent.BLOCK_ENTITIES.register();
        ItemContent.ITEMS.register();
        ComponentContent.COMPONENT_TYPES.register();
        ItemGroups.TABS.register();
        TickEvent.SERVER_POST.register(event -> event.getAllLevels().forEach(world -> world.players().forEach(DroneController::tickPlayer)));
        TickEvent.SERVER_PRE.register(event -> event.getAllLevels().forEach(DroneLight::removeOldLights));
        TickEvent.SERVER_POST.register(event -> {
            DELAYED_ACTIONS.forEach(Runnable::run);
            DELAYED_ACTIONS.clear();
        });
        PlayerEvent.ATTACK_ENTITY.register(DroneController::onPlayerAttackEntityEvent);
        NetworkContent.init();
        BlockContent.registerItems();
    }
}

