/*
 * Decompiled with CFR 0.152.
 */
package rearth;

import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import rearth.Drones;
import rearth.blocks.controller.ControllerBlockEntity;
import rearth.client.ui.DroneCreatorScreen;
import rearth.init.BlockContent;
import rearth.init.BlockEntitiesContent;
import rearth.init.NetworkContent;

public final class DronesClient {
    public static Map<Supplier<Block>, RenderType> RENDER_LAYERS = new HashMap<Supplier<Block>, RenderType>();
    public static final HashMap<Integer, NetworkContent.DroneMoveSyncPacket> CURRENT_DATA = new HashMap();

    public static void init() {
        Drones.LOGGER.info("Hello from drones client");
        NetworkAggregator.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, NetworkContent.OpenDroneScreenPacket.PAYLOAD_ID, NetworkContent.OpenDroneScreenPacket.PACKET_CODEC, List.of(), DronesClient::onAssembleScreenPacket);
        RENDER_LAYERS.put((Supplier<Block>)BlockContent.WOOD_ROTOR, RenderType.cutout());
        RENDER_LAYERS.put((Supplier<Block>)BlockContent.IRON_ROTOR, RenderType.cutout());
        RENDER_LAYERS.put((Supplier<Block>)BlockContent.ION_THRUSTER, RenderType.cutout());
    }

    public static void onAssembleScreenPacket(NetworkContent.OpenDroneScreenPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        Level world = player.level();
        BlockPos pos = packet.controllerPos();
        Optional candidate = world.getBlockEntity(pos, (BlockEntityType)BlockEntitiesContent.ASSEMBLER_CONTROLLER.get());
        candidate.ifPresent(controllerBlockEntity -> Minecraft.getInstance().setScreen((Screen)new DroneCreatorScreen(((ControllerBlockEntity)((Object)((Object)candidate.get()))).getCurrentDroneData(), pos)));
    }
}

