/*
 * Decompiled with CFR 0.152.
 */
package rearth.blocks.controller;

import com.mojang.serialization.MapCodec;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.blocks.controller.ControllerBlockEntity;
import rearth.drone.DroneData;
import rearth.init.BlockEntitiesContent;
import rearth.init.ComponentContent;
import rearth.init.ItemContent;
import rearth.init.NetworkContent;

public class ControllerBlock
extends BaseEntityBlock {
    public ControllerBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ControllerBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.drones.builder").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        super.appendHoverText(stack, context, tooltip, options);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Optional candidate = world.getBlockEntity(pos, (BlockEntityType)BlockEntitiesContent.ASSEMBLER_CONTROLLER.get());
            candidate.ifPresent(controllerBlockEntity -> NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new NetworkContent.OpenDroneScreenPacket(pos)));
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.is((Item)ItemContent.POCKET_DRONE.get()) && stack.has((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get())) {
            boolean imported;
            System.out.println("Loading pocket drone");
            DroneData stackData = (DroneData)stack.get((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get());
            Optional candidate = world.getBlockEntity(pos, (BlockEntityType)BlockEntitiesContent.ASSEMBLER_CONTROLLER.get());
            if (candidate.isPresent() && !world.isClientSide() && (imported = ((ControllerBlockEntity)((Object)candidate.get())).loadDroneToWorld(stackData))) {
                stack.shrink(1);
                return ItemInteractionResult.CONSUME;
            }
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }
}

