/*
 * Decompiled with CFR 0.152.
 */
package rearth.blocks.controller;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.Drones;
import rearth.drone.DroneData;
import rearth.drone.RecordedBlock;
import rearth.init.BlockContent;
import rearth.init.BlockEntitiesContent;
import rearth.init.ComponentContent;
import rearth.init.ItemContent;
import rearth.util.FloodFill;

public class ControllerBlockEntity
extends BlockEntity {
    public static final float LOW_THRUSTER_POWER = 10.0f;
    public static final float MEDIUM_THRUSTER_POWER = 25.0f;
    public static final float HIGH_THRUSTER_POWER = 40.0f;
    public static final float ULTRA_THRUSTER_POWER = 60.0f;

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitiesContent.ASSEMBLER_CONTROLLER.get(), pos, state);
    }

    public List<BlockPos> getPlatformBlocks() {
        Optional<BlockPos> frameStart = this.getPlatformStart();
        if (frameStart.isEmpty()) {
            return List.of();
        }
        List<BlockPos> frameBlocks = FloodFill.Run(this.level, frameStart.get(), candidate -> candidate.is(BlockContent.ASSEMBLER_FRAME), checkPos -> true, 200, false);
        if (frameBlocks.isEmpty()) {
            return List.of();
        }
        return frameBlocks;
    }

    @Nullable
    public DroneData getCurrentDroneData() {
        List<BlockPos> frameBlocks = this.getPlatformBlocks();
        if (frameBlocks.isEmpty()) {
            return null;
        }
        BlockPos droneStart = null;
        for (BlockPos frameBlock : frameBlocks) {
            BlockPos frameAbove = frameBlock.above();
            BlockState candidateState = this.level.getBlockState(frameAbove);
            if (!ControllerBlockEntity.isValidDroneBlock(candidateState)) continue;
            droneStart = frameAbove;
            break;
        }
        if (droneStart == null) {
            return null;
        }
        List<BlockPos> droneBlocks = FloodFill.Run(this.level, droneStart, ControllerBlockEntity::isValidDroneBlock, this::isAboveOwnFrame, 1000, true);
        BlockPos droneCenter = ControllerBlockEntity.findCenterOfMass(droneBlocks);
        System.out.println("drone: " + String.valueOf(droneBlocks));
        ArrayList<RecordedBlock> blockData = new ArrayList<RecordedBlock>();
        for (BlockPos blockPos : droneBlocks) {
            BlockState blockState = this.level.getBlockState(blockPos);
            BlockPos localPos = blockPos.subtract((Vec3i)droneCenter);
            RecordedBlock data = new RecordedBlock(blockState, (Vec3i)localPos);
            blockData.add(data);
        }
        int droneId = this.level.getRandom().nextInt(Integer.MAX_VALUE);
        BlockPos droneOffset = droneCenter.subtract((Vec3i)this.worldPosition);
        return new DroneData(blockData, droneId, (Vec3i)droneOffset);
    }

    private boolean isAboveOwnFrame(BlockPos pos) {
        int maxRange = 20;
        for (int i = 1; i <= maxRange; ++i) {
            BlockPos testPos = pos.below(i);
            if (!this.level.getBlockState(testPos).is(BlockContent.ASSEMBLER_FRAME)) continue;
            return true;
        }
        return false;
    }

    private static BlockPos findCenterOfMass(List<BlockPos> positions) {
        if (positions.isEmpty()) {
            Drones.LOGGER.warn("tried to find COM for empty drone");
            return BlockPos.ZERO;
        }
        double dataX = 0.0;
        double dataY = 0.0;
        double dataZ = 0.0;
        for (BlockPos pos : positions) {
            Vec3 center = pos.getCenter();
            dataX += center.x;
            dataY += center.y;
            dataZ += center.z;
        }
        Vec3 realCOM = new Vec3(dataX / (double)positions.size(), dataY / (double)positions.size(), dataZ / (double)positions.size());
        return BlockPos.containing((Position)realCOM);
    }

    private Optional<BlockPos> getPlatformStart() {
        for (BlockPos neighbor : FloodFill.GetHorizontalNeighbors(this.worldPosition)) {
            if (!this.level.getBlockState(neighbor).is(BlockContent.ASSEMBLER_FRAME)) continue;
            return Optional.of(neighbor);
        }
        return Optional.empty();
    }

    public boolean loadDroneToWorld(DroneData data) {
        BlockPos worldPos;
        Vec3i offset;
        if (this.getCurrentDroneData() != null) {
            return false;
        }
        for (RecordedBlock droneBlockData : data.getBlocks()) {
            offset = droneBlockData.localPos();
            worldPos = this.worldPosition.offset(data.getAssemblerOffset()).offset(offset);
            if (!this.isAboveOwnFrame(worldPos)) {
                return false;
            }
            BlockState worldState = this.level.getBlockState(worldPos);
            if (worldState.isAir()) continue;
            return false;
        }
        this.level.playSound(null, this.worldPosition, SoundEvents.SHROOMLIGHT_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        for (RecordedBlock droneBlockData : data.getBlocks()) {
            offset = droneBlockData.localPos();
            worldPos = this.worldPosition.offset(data.getAssemblerOffset()).offset(offset);
            this.level.setBlockAndUpdate(worldPos, droneBlockData.state());
            Level level = this.level;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 spawnAt = worldPos.getCenter();
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.GUST, spawnAt.x, spawnAt.y, spawnAt.z, 1, 0.0, (double)0.1f, 0.0, 0.5);
        }
        return true;
    }

    private static boolean isValidDroneBlock(BlockState state) {
        return !state.isAir() && !state.liquid() && !state.is(BlockContent.ASSEMBLER_FRAME) && !state.is(BlockContent.ASSEMBLER_CONTROLLER);
    }

    public void assembleDrone(Player player, String name) {
        Drones.LOGGER.info("Assembling drone for: {}, drone name: {}", (Object)player.getName(), (Object)name);
        DroneData droneData = this.getCurrentDroneData();
        if (droneData == null) {
            Drones.LOGGER.warn("Player tried to create empty/invalid drone");
            return;
        }
        ItemStack createdStack = new ItemStack(ItemContent.POCKET_DRONE);
        createdStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
        createdStack.set((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get(), (Object)droneData);
        ItemEntity itemEntity = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), createdStack);
        this.level.addFreshEntity((Entity)itemEntity);
        for (RecordedBlock droneBlock : droneData.getBlocks()) {
            BlockPos worldPos = this.worldPosition.offset(droneData.getAssemblerOffset()).offset(droneBlock.localPos());
            this.level.setBlockAndUpdate(worldPos, Blocks.AIR.defaultBlockState());
            Level level = this.level;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 spawnAt = worldPos.getCenter();
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.GUST, spawnAt.x, spawnAt.y, spawnAt.z, 1, 0.0, (double)0.1f, 0.0, 0.5);
        }
    }

    public record AssembleDronePacket(String name, BlockPos controllerPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AssembleDronePacket> PAYLOAD_ID = new CustomPacketPayload.Type(Drones.id("assemble"));
        public static final StreamCodec<ByteBuf, AssembleDronePacket> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AssembleDronePacket::name, (StreamCodec)BlockPos.STREAM_CODEC, AssembleDronePacket::controllerPos, AssembleDronePacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PAYLOAD_ID;
        }
    }
}

