/*
 * Decompiled with CFR 0.152.
 */
package rearth.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rearth.DronesClient;
import rearth.drone.DroneController;
import rearth.drone.DroneData;
import rearth.drone.RecordedBlock;
import rearth.init.NetworkContent;
import rearth.util.FloodFill;
import rearth.util.Helpers;

public class DroneRenderer {
    private static final HashMap<Player, Vec3> lastPositions = new HashMap();
    private static final HashMap<Player, Vec3> lastRotations = new HashMap();

    public static void doRender(PoseStack matrices, Camera camera, MultiBufferSource vertexConsumers) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        for (AbstractClientPlayer dronePlayer : world.players()) {
            Optional<DroneData> droneCandidate = DroneController.getDroneOfPlayer((Player)dronePlayer);
            if (droneCandidate.isEmpty()) continue;
            DroneData droneData = droneCandidate.get();
            NetworkContent.DroneMoveSyncPacket movementData = DronesClient.CURRENT_DATA.get(droneData.getDroneId());
            if (movementData == null) {
                return;
            }
            float tickDelta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
            float targetScale = 0.15f * droneData.getRenderScale();
            Vec3 lastPos = lastPositions.computeIfAbsent((Player)dronePlayer, player -> movementData.position());
            Vec3 lastRot = lastRotations.computeIfAbsent((Player)dronePlayer, player -> movementData.rotation());
            Vec3 newPos = movementData.position();
            Vec3 newRot = movementData.rotation();
            double rotDistY = Math.abs(lastRot.y - newRot.y);
            double altRotDistY = Math.abs(-lastRot.y - newRot.y);
            if (altRotDistY < rotDistY && Math.abs(lastRot.y) > 90.0) {
                boolean positive = lastRot.y > 0.0;
                double adjustedY = positive ? lastRot.y - 360.0 : lastRot.y + 360.0;
                lastRot = new Vec3(lastRot.x, adjustedY, lastRot.z);
            }
            Vec3 deltaDronePos = Helpers.lerp(lastPos, newPos, 0.1f);
            lastPositions.put((Player)dronePlayer, deltaDronePos);
            Vec3 deltaDroneRot = Helpers.lerp(lastRot, newRot, 0.02f);
            lastRotations.put((Player)dronePlayer, deltaDroneRot);
            matrices.pushPose();
            matrices.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
            matrices.translate(deltaDronePos.x, deltaDronePos.y, deltaDronePos.z);
            matrices.mulPose(Axis.XP.rotationDegrees((float)(-deltaDroneRot.x)));
            matrices.mulPose(Axis.ZP.rotationDegrees((float)(-deltaDroneRot.z)));
            matrices.mulPose(Axis.YP.rotationDegrees((float)(-deltaDroneRot.y)));
            for (RecordedBlock blockData : droneData.getBlocks()) {
                Vec3i localOffset = blockData.localPos();
                BlockState state = blockData.state();
                Vec3 scaledLocalOffset = Vec3.atLowerCornerOf((Vec3i)localOffset).add(-0.5, -0.5, -0.5).scale((double)targetScale);
                matrices.pushPose();
                matrices.translate(scaledLocalOffset.x, scaledLocalOffset.y, scaledLocalOffset.z);
                matrices.scale(targetScale, targetScale, targetScale);
                int light = DroneRenderer.getMaxLight(BlockPos.containing((Position)movementData.position()), (Level)world);
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrices, vertexConsumers, light, OverlayTexture.NO_OVERLAY);
                Block block = state.getBlock();
                if (block instanceof EntityBlock) {
                    EntityBlock blockEntityProvider = (EntityBlock)block;
                    BlockEntity blockEntity = blockEntityProvider.newBlockEntity(new BlockPos(localOffset), state);
                    blockEntity.setLevel((Level)world);
                    BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity);
                    if (renderer != null) {
                        renderer.render(blockEntity, 0.0f, matrices, vertexConsumers, light, OverlayTexture.NO_OVERLAY);
                    }
                }
                matrices.popPose();
            }
            matrices.popPose();
        }
    }

    private static int getMaxLight(BlockPos center, Level world) {
        int bestLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)center);
        for (BlockPos side : FloodFill.GetNeighbors(center)) {
            int candidate = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)side);
            bestLight = Math.max(candidate, bestLight);
        }
        return bestLight;
    }
}

