/*
 * Decompiled with CFR 0.152.
 */
package rearth.client.ui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.Drones;
import rearth.blocks.controller.ControllerBlockEntity;
import rearth.drone.DroneData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;

public class DroneCreatorScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = Drones.id("textures/gui/assembler.png");
    private static final ResourceLocation BIG_BUTTON_TEXTURE = Drones.id("textures/gui/big_button.png");
    private static final ResourceLocation BIG_BUTTON_HOVER_TEXTURE = Drones.id("textures/gui/big_button_hover.png");
    private static final ResourceLocation BIG_BUTTON_PRESSED_TEXTURE = Drones.id("textures/gui/big_button_pressed.png");
    private static final ResourceLocation SLOT_PANEL_TEXTURE = Drones.id("textures/gui/slot_panel.png");
    private final DroneData droneData;
    private final HashMap<Vec3i, BlockEntity> renderedEntities = new HashMap();
    private float openTime = 0.0f;
    private final BlockPos machinePos;
    private float previewAngle = 0.0f;
    private EditBox nameField;

    public DroneCreatorScreen(DroneData data, BlockPos machinePos) {
        super((Component)Component.empty());
        this.machinePos = machinePos;
        if (data == null) {
            data = new DroneData(List.of(), 1, Vec3i.ZERO);
        }
        this.droneData = data;
        for (RecordedBlock pair : this.droneData.getBlocks()) {
            EntityBlock blockEntityProvider;
            BlockEntity blockEntity;
            BlockState state = pair.state();
            Block block = state.getBlock();
            if (!(block instanceof EntityBlock) || (blockEntity = (blockEntityProvider = (EntityBlock)block).newBlockEntity(new BlockPos(pair.localPos()), state)) == null || this.minecraft == null) continue;
            blockEntity.setLevel((Level)this.minecraft.level);
            BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(blockEntity);
            if (renderer == null) continue;
            this.renderedEntities.put(pair.localPos(), blockEntity);
        }
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int backgroundStartX = centerX - 150;
        int backgroundStartY = centerY - 91;
        int buttonX = backgroundStartX + 154;
        int buttonY = backgroundStartY + 113;
        int nameX = backgroundStartX + 7;
        int nameY = backgroundStartY + 140;
        BigDroneButton buttonWidget = new BigDroneButton(buttonX, buttonY, 138, 59, (Component)Component.literal((String)"BUILD!").withStyle(ChatFormatting.BOLD), button -> {}, this);
        this.addRenderableWidget((GuiEventListener)buttonWidget);
        this.nameField = new EditBox(this.font, nameX, nameY, 138, 32, (Component)Component.literal((String)"Input"));
        this.nameField.setMaxLength(32);
        this.nameField.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.drones.name_field")));
        this.nameField.setValue("Dronie");
        this.addRenderableWidget((GuiEventListener)this.nameField);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        int textColor = 13685204;
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int backgroundStartX = centerX - 150;
        int backgroundStartY = centerY - 91;
        context.blit(BACKGROUND_TEXTURE, backgroundStartX, backgroundStartY, 0, 0.0f, 0.0f, 300, 183, 300, 183);
        for (RecordedBlock pair : this.droneData.getBlocks()) {
            BlockEntity entity = this.renderedEntities.get(pair.localPos());
            this.renderBlock(context, pair.localPos(), pair.state(), entity, delta);
        }
        for (Renderable drawable : this.renderables) {
            drawable.render(context, mouseX, mouseY, delta);
        }
        context.drawString(this.font, (Component)Component.literal((String)"Speed:"), backgroundStartX + 161, backgroundStartY + 13, textColor, false);
        context.drawString(this.font, (Component)Component.literal((String)"Size:"), backgroundStartX + 161, backgroundStartY + 44, textColor, false);
        int greenColor = -12810969;
        int orangeColor = -1012726;
        int markerColor = -3092012;
        int endColor = -526345;
        float speedBarFill = this.getSpeedProgress();
        int speedColor = (double)speedBarFill > 0.25 ? greenColor : orangeColor;
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.0f, speedBarFill, speedColor, 5, 0);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.248f, 0.252f, markerColor, 3, 1);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.498f, 0.502f, markerColor, 3, 1);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.748f, 0.752f, markerColor, 3, 1);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, speedBarFill - 0.005f, speedBarFill + 0.005f, endColor, 5, 0);
        float sizeBarFill = this.getSizeProgress();
        int sizeColor = (double)sizeBarFill < 0.75 ? greenColor : orangeColor;
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.0f, sizeBarFill, sizeColor, 5, 32);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.248f, 0.252f, markerColor, 3, 33);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.498f, 0.502f, markerColor, 3, 33);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.748f, 0.752f, markerColor, 3, 33);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, sizeBarFill - 0.005f, sizeBarFill + 0.005f, endColor, 5, 32);
        int abilitiesStartX = backgroundStartX + 159;
        int abilitiesStartY = backgroundStartY + 80;
        int index = 0;
        for (DroneBehaviour.BlockFunctions ability : this.droneData.installed) {
            boolean isHovered;
            if (ability.equals((Object)DroneBehaviour.BlockFunctions.FLIGHT)) continue;
            int startAtX = abilitiesStartX + index * 23;
            context.blit(SLOT_PANEL_TEXTURE, startAtX, abilitiesStartY, 0, 0.0f, 0.0f, 20, 20, 20, 20);
            boolean bl = isHovered = mouseX > startAtX && mouseX < startAtX + 20 && mouseY > abilitiesStartY && mouseY < abilitiesStartY + 20;
            if (isHovered) {
                context.renderTooltip(this.font, (Component)Component.translatable((String)("drones.ability." + ability.name().toLowerCase())), startAtX, abilitiesStartY + 40);
                for (int i = 0; i < 5; ++i) {
                    String tooltipKey = "drones.ability." + ability.name().toLowerCase() + "." + i;
                    if (!I18n.exists((String)tooltipKey)) continue;
                    context.renderTooltip(this.font, (Component)Component.translatable((String)tooltipKey), startAtX, abilitiesStartY + 40 + 11 + i * 10);
                }
            }
            Item renderedItem = DroneBehaviour.getItem(ability);
            DroneCreatorScreen.drawItem(context, renderedItem, startAtX + 2, abilitiesStartY + 2, 16);
            ++index;
        }
        if (index == 0) {
            context.drawString(this.font, (Component)Component.literal((String)"No Abilities"), abilitiesStartX + 5, abilitiesStartY + 7, textColor, false);
        }
        this.openTime += delta;
    }

    private void drawBarPart(GuiGraphics context, int backgroundStartX, int backgroundStartY, float fillStart, float fillEnd, int color, int height, int yOffset) {
        int speedFromX = backgroundStartX + 161 + (int)(124.0f * fillStart);
        int speedFromY = backgroundStartY + 26 + yOffset;
        int speedToX = backgroundStartX + 161 + (int)(124.0f * fillEnd);
        int speedToY = speedFromY + height;
        context.fill(speedFromX, speedFromY, speedToX, speedToY, 10, color);
    }

    private void renderBlock(GuiGraphics context, Vec3i offset, BlockState state, @Nullable BlockEntity entity, float partialTicks) {
        int x = this.width / 2 - 150 + 70;
        int y = this.height / 2 - 30;
        int size = 20;
        float rotation = this.openTime * 2.0f % 360.0f;
        float scale = this.droneData.getRenderScale();
        context.pose().pushPose();
        context.pose().translate((float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, 400.0f);
        context.pose().scale((float)(40 * size) / 64.0f, (float)(-40 * size) / 64.0f, 40.0f);
        context.pose().scale(scale, scale, scale);
        context.pose().mulPose(Axis.XP.rotationDegrees(30.0f + this.previewAngle));
        context.pose().mulPose(Axis.YP.rotationDegrees(225.0f + rotation));
        context.pose().translate(-0.5 + (double)offset.getX(), -0.5 + (double)offset.getY(), -0.5 + (double)offset.getZ());
        RenderSystem.runAsFancy(() -> {
            BlockEntityRenderer entityRenderer;
            MultiBufferSource.BufferSource vertexConsumers = this.minecraft.renderBuffers().bufferSource();
            if (state.getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) {
                this.minecraft.getBlockRenderer().renderSingleBlock(state, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            if (entity != null && (entityRenderer = this.minecraft.getBlockEntityRenderDispatcher().getRenderer(entity)) != null) {
                entityRenderer.render(entity, partialTicks, context.pose(), (MultiBufferSource)vertexConsumers, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            RenderSystem.setShaderLights((Vector3f)new Vector3f(-1.5f, -0.5f, 0.0f), (Vector3f)new Vector3f(0.0f, -1.0f, 0.0f));
            vertexConsumers.endBatch();
            Lighting.setupFor3DItems();
        });
        context.pose().popPose();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (Math.abs(deltaY) > 0.001) {
            int centerX = this.width / 2;
            int centerY = this.height / 2;
            int backgroundStartX = centerX - 150;
            int backgroundStartY = centerY - 91;
            int previewStartX = backgroundStartX + 5;
            int previewEndX = previewStartX + 140;
            int previewStartY = backgroundStartY + 5;
            int previewEndY = previewStartY + 170;
            if (mouseX < (double)previewEndX && mouseX > (double)previewStartX && mouseY < (double)previewEndY && mouseY > (double)previewStartY) {
                this.previewAngle = (float)((double)this.previewAngle + deltaY);
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private float getSpeedProgress() {
        return Math.clamp(this.droneData.power / 10.0f, 0.01f, 1.0f);
    }

    private float getSizeProgress() {
        return Math.clamp((float)this.droneData.getSize() / 10.0f, 0.1f, 1.0f);
    }

    private static void drawItem(GuiGraphics context, Item item, int x, int y, int size) {
        boolean notSideLit;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        MultiBufferSource.BufferSource entityBuffers = Minecraft.getInstance().renderBuffers().bufferSource();
        ItemStack stack = new ItemStack((ItemLike)item);
        boolean bl = notSideLit = !itemRenderer.getModel(stack, null, null, 0).usesBlockLight();
        if (notSideLit) {
            Lighting.setupForFlatItems();
        }
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)x, (float)y, 100.0f);
        matrices.scale((float)size / 16.0f, (float)size / 16.0f, 1.0f);
        matrices.translate(8.0, 8.0, 0.0);
        if (notSideLit) {
            matrices.scale(16.0f, -16.0f, 16.0f);
        } else {
            matrices.mulPose(new Matrix4f().scaling(16.0f, -16.0f, 16.0f));
        }
        Minecraft client = Minecraft.getInstance();
        itemRenderer.renderStatic(stack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.NO_OVERLAY, matrices, (MultiBufferSource)entityBuffers, (Level)client.level, 0);
        entityBuffers.endBatch();
        matrices.popPose();
        if (notSideLit) {
            Lighting.setupFor3DItems();
        }
    }

    public void assembleDrone() {
        if (!this.droneData.isValid()) {
            this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"drone.message.invalid_drone"), (Component)Component.translatable((String)"drone.message.invalid_drone_desc")));
            return;
        }
        this.minecraft.getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.minecraft, (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)Component.translatable((String)"drone.message.assembled"), (Component)Component.translatable((String)"drone.message.assembled_desc")));
        NetworkManager.sendToServer((CustomPacketPayload)new ControllerBlockEntity.AssembleDronePacket(this.nameField.getValue(), this.machinePos));
        this.onClose();
    }

    private static class BigDroneButton
    extends Button {
        private boolean isPressed = false;
        private final DroneCreatorScreen parent;

        protected BigDroneButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, DroneCreatorScreen parent) {
            super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
            this.parent = parent;
        }

        public void onPress() {
            this.isPressed = true;
            super.onPress();
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            boolean valid = super.mouseReleased(mouseX, mouseY, button);
            if (valid && this.isPressed) {
                this.isPressed = false;
                this.parent.assembleDrone();
                this.playUpSound(Minecraft.getInstance().getSoundManager());
            }
            return valid;
        }

        public void playDownSound(SoundManager soundManager) {
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.NETHER_WOOD_PRESSURE_PLATE_CLICK_ON, (float)0.7f));
        }

        public void playUpSound(SoundManager soundManager) {
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BEACON_DEACTIVATE, (float)0.7f));
        }

        protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            ResourceLocation usedTexture = BIG_BUTTON_TEXTURE;
            if (this.isHovered()) {
                usedTexture = BIG_BUTTON_HOVER_TEXTURE;
            }
            if (this.isPressed) {
                usedTexture = BIG_BUTTON_PRESSED_TEXTURE;
            }
            context.blit(usedTexture, this.getX(), this.getY(), 0, 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
            float scale = 3.4f;
            int textX = this.getX() + 11;
            int textY = this.getY() + 13;
            int textColor = 13685204;
            if (this.isHovered()) {
                textY += 4;
            }
            if (this.isPressed) {
                textY += 6;
            }
            context.pose().pushPose();
            context.pose().scale(scale, scale, scale);
            textX = (int)((float)textX / scale);
            textY = (int)((float)textY / scale);
            context.drawString(Minecraft.getInstance().font, this.getMessage(), textX, textY, textColor, false);
            context.pose().popPose();
        }
    }
}

