/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone;

import com.mojang.datafixers.util.Pair;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import io.wispforest.accessories.api.AccessoriesContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.drone.DroneData;
import rearth.drone.DroneServerData;
import rearth.drone.behaviour.BeamAttackBehaviour;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneLight;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.MeleeAttackBehaviour;
import rearth.drone.behaviour.MiningSupportBehaviour;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.ComponentContent;
import rearth.init.ItemContent;
import rearth.init.NetworkContent;
import rearth.util.Helpers;

public class DroneController {
    public static final int SNAP_RANGE = 30;
    private static final HashMap<Integer, DroneServerData> WORK_DATA = new HashMap();
    public static final SimplexNoise SIMPLEX = new SimplexNoise(RandomSource.create());

    public static void tickPlayer(ServerPlayer playerEntity) {
        Optional<DroneServerData> droneCandidate = DroneController.getPlayerServerData((Player)playerEntity);
        droneCandidate.ifPresent(serverData -> DroneController.updateDrone((Player)playerEntity, serverData));
    }

    public static void updateDrone(Player player, DroneServerData serverData) {
        if (serverData.getCurrentTask() == null) {
            serverData.setCurrentTask(new PlayerSwarmBehaviour(serverData, player));
        }
        if (serverData.droneData.isGlowing()) {
            DroneLight.updateDroneLight(serverData, player.level());
        }
        DroneController.updateDroneSensors(player, serverData);
        serverData.getCurrentTask().tick();
        DroneController.updateDroneMovement(player, serverData);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            List nearbyPlayers = serverWorld.getPlayers(candidate -> candidate.position().distanceToSqr(player.position()) < 10000.0);
            NetworkManager.sendToPlayers((Iterable)nearbyPlayers, (CustomPacketPayload)new NetworkContent.DroneMoveSyncPacket(serverData.currentPosition, serverData.currentRotation, serverData.droneData.getDroneId()));
        }
    }

    private static void updateDroneSensors(Player player, DroneServerData serverData) {
        int currentPriority = serverData.getCurrentTask().getPriority();
        for (DroneSensor sensor : serverData.droneData.enabledSensors) {
            if (currentPriority >= sensor.getPriority() || sensor.sense(serverData, player)) break;
        }
    }

    private static void updateDroneMovement(Player player, DroneServerData serverData) {
        boolean positionBlocked;
        Level level;
        float powerMultiplier = serverData.droneData.power;
        float accelerationPower = 0.2f;
        double bankingFactor = 30.0 * Math.sqrt(powerMultiplier);
        Vec3 currentVelocity = serverData.currentVelocity;
        Vec3 targetOffset = serverData.targetPosition.subtract(serverData.currentPosition);
        Vec3 velocityDelta = targetOffset.subtract(currentVelocity);
        double rotationAngle = serverData.currentRotation.y;
        double bankX = Math.clamp(velocityDelta.z * -bankingFactor, -45.0, 45.0);
        double bankZ = Math.clamp(velocityDelta.x * bankingFactor, -45.0, 45.0);
        double acceleration = velocityDelta.length();
        double spawnChance = acceleration - 0.5;
        if ((double)player.level().getRandom().nextFloat() < spawnChance && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMALL_GUST, serverData.currentPosition.x, serverData.currentPosition.y - (double)0.2f, serverData.currentPosition.z, 1, (double)0.1f, 0.1, 0.1, (double)0.1f);
        }
        if (serverData.getCurrentTask() != null) {
            rotationAngle = serverData.getCurrentTask().getCurrentYaw();
            bankX += (double)serverData.getCurrentTask().getExtraRoll();
        }
        serverData.currentRotation = new Vec3(bankX, rotationAngle, bankZ);
        serverData.currentVelocity = currentVelocity.add(velocityDelta.scale((double)accelerationPower));
        Vec3 nextPosition = serverData.currentPosition.add(serverData.currentVelocity.scale((double)(powerMultiplier / 20.0f)));
        boolean bl = positionBlocked = !Helpers.isLineAvailable(player.level(), serverData.currentPosition, nextPosition);
        if (serverData.ghostTicks > 0) {
            --serverData.ghostTicks;
            serverData.currentPosition = nextPosition;
        } else if (serverData.ghostWaitTime > 0) {
            --serverData.ghostWaitTime;
            if (serverData.ghostWaitTime == 0) {
                serverData.ghostTicks = 20;
            }
        } else if (positionBlocked) {
            serverData.currentVelocity = Vec3.ZERO;
            serverData.ghostWaitTime = 14;
            Level level2 = player.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level2;
                Vec3 middle = serverData.currentPosition;
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.PORTAL, middle.x, middle.y, middle.z, 15, 0.0, 0.0, 0.0, (double)0.2f);
            }
        } else {
            serverData.currentPosition = nextPosition;
            serverData.ghostTicks = 0;
            serverData.ghostWaitTime = 0;
        }
        double playerDist = serverData.currentPosition.distanceTo(player.getEyePosition());
        if (playerDist > 30.0) {
            serverData.currentPosition = player.getEyePosition();
        }
    }

    public static Optional<DroneServerData> getPlayerServerData(Player playerEntity) {
        Optional<DroneData> droneCandidate = DroneController.getDroneOfPlayer(playerEntity);
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            if (droneCandidate.isPresent()) {
                DroneServerData serverData = WORK_DATA.computeIfAbsent(droneCandidate.get().getDroneId(), droneId -> new DroneServerData((DroneData)droneCandidate.get(), serverPlayer));
                return Optional.of(serverData);
            }
        }
        return Optional.empty();
    }

    public static Optional<DroneData> getDroneOfPlayer(Player playerEntity) {
        ItemStack droneCandidate = playerEntity.getItemBySlot(EquipmentSlot.HEAD);
        if (droneCandidate.is((Item)ItemContent.POCKET_DRONE.get()) && droneCandidate.has((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get())) {
            DroneData droneData = (DroneData)droneCandidate.get((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get());
            if (droneData == null) {
                return Optional.empty();
            }
            return Optional.of(droneData);
        }
        if (Platform.isModLoaded((String)"accessories") && playerEntity.accessoriesCapability() != null && playerEntity.accessoriesCapability().getContainers() != null) {
            AccessoriesContainer headCosmetic = (AccessoriesContainer)playerEntity.accessoriesCapability().getContainers().get("accessories:head");
            if (headCosmetic == null) {
                return Optional.empty();
            }
            for (Pair pair : headCosmetic.getCosmeticAccessories()) {
                ItemStack candidate = (ItemStack)pair.getSecond();
                if (!candidate.is((Item)ItemContent.POCKET_DRONE.get()) || !candidate.has((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get())) continue;
                DroneData droneData = (DroneData)candidate.get((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get());
                if (droneData == null) {
                    return Optional.empty();
                }
                return Optional.of(droneData);
            }
        }
        return Optional.empty();
    }

    private static void issueAttackCommend(Player player, DroneServerData serverData, LivingEntity livingEntity) {
        if (serverData.droneData.installed.contains((Object)DroneBehaviour.BlockFunctions.BEAM)) {
            serverData.setCurrentTask(new BeamAttackBehaviour(livingEntity, player, serverData));
            return;
        }
        if (serverData.droneData.installed.contains((Object)DroneBehaviour.BlockFunctions.MELEE_ATTACK)) {
            serverData.setCurrentTask(new MeleeAttackBehaviour(livingEntity, player, serverData));
        }
    }

    public static EventResult onPlayerAttackEntityEvent(Player player, Level world, Entity entity, InteractionHand hand, @Nullable EntityHitResult entityHitResult) {
        Optional<DroneServerData> droneCandidate = DroneController.getPlayerServerData(player);
        if (droneCandidate.isPresent() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            DroneController.issueAttackCommend(player, droneCandidate.get(), livingEntity);
        }
        return EventResult.pass();
    }

    public static void onPlayerBlockBreakStart(Player player, BlockPos blockPos) {
        Optional<DroneServerData> droneCandidate = DroneController.getPlayerServerData(player);
        if (droneCandidate.isPresent() && MiningSupportBehaviour.isValidMiningTarget(player.level(), blockPos) && droneCandidate.get().droneData.installed.contains((Object)DroneBehaviour.BlockFunctions.MINING_SUPPORT)) {
            droneCandidate.get().setCurrentTask(new MiningSupportBehaviour(blockPos, player, droneCandidate.get()));
        }
    }
}

