/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import rearth.Drones;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.ArrowAttackBehaviour;
import rearth.drone.behaviour.BeamAttackBehaviour;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.MeleeAttackBehaviour;
import rearth.drone.behaviour.MiningSupportBehaviour;
import rearth.drone.behaviour.PickupBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class DroneData {
    private final List<RecordedBlock> blocks;
    private final int size;
    private final int droneId;
    private final Vec3i assemblerOffset;
    public final EnumSet<DroneBehaviour.BlockFunctions> installed;
    public final float power;
    public final List<DroneSensor> enabledSensors;
    public static StreamCodec<ByteBuf, DroneData> PACKET_CODEC = StreamCodec.composite((StreamCodec)RecordedBlock.PACKET_CODEC.apply(ByteBufCodecs.list()), DroneData::getBlocks, (StreamCodec)ByteBufCodecs.INT, DroneData::getDroneId, Helpers.VEC3I_PACKET_CODEC, DroneData::getAssemblerOffset, DroneData::new);
    public static Codec<DroneData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RecordedBlock.CODEC.listOf().fieldOf("blocks").forGetter(DroneData::getBlocks), (App)ExtraCodecs.POSITIVE_INT.fieldOf("id").forGetter(DroneData::getDroneId), (App)Vec3i.CODEC.fieldOf("offset").forGetter(DroneData::getAssemblerOffset)).apply((Applicative)instance, DroneData::new));

    public DroneData(@NotNull List<RecordedBlock> blocks, int id, Vec3i assemblerOffset) {
        this.blocks = blocks;
        this.droneId = id;
        this.assemblerOffset = assemblerOffset;
        float weight = 0.0f;
        float thrust = 0.0f;
        ArrayList<DroneBehaviour.BlockFunctions> abilities = new ArrayList<DroneBehaviour.BlockFunctions>();
        abilities.add(DroneBehaviour.BlockFunctions.FLIGHT);
        boolean light = false;
        HashMap<Vec3i, BlockState> droneFrame = new HashMap<Vec3i, BlockState>();
        blocks.forEach(block -> droneFrame.put(block.localPos(), block.state()));
        int minX = 0;
        int minZ = 0;
        int maxX = 0;
        int maxZ = 0;
        for (RecordedBlock recordedBlock : blocks) {
            Vec3i localPos;
            BlockState state = recordedBlock.state();
            weight += state.getBlock().defaultDestroyTime();
            thrust += DroneData.getThrust(recordedBlock, droneFrame);
            if (ArrowAttackBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.ARROW_LAUNCHER);
            }
            if (MeleeAttackBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.MELEE_ATTACK);
            }
            if (MiningSupportBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.MINING_SUPPORT);
            }
            if (PickupBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.PICKUP);
            }
            if (BeamAttackBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.BEAM);
            }
            if (state.getLightEmission() > 5) {
                abilities.add(DroneBehaviour.BlockFunctions.LIGHT);
            }
            if ((localPos = recordedBlock.localPos()).getX() < minX) {
                minX = localPos.getX();
            }
            if (localPos.getZ() < minZ) {
                minZ = localPos.getZ();
            }
            if (localPos.getX() > maxX) {
                maxX = localPos.getX();
            }
            if (localPos.getZ() <= maxZ) continue;
            maxZ = localPos.getZ();
        }
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        this.size = Math.max(sizeX, sizeZ);
        float thrusterRatio = thrust / weight;
        if (thrusterRatio < 1.0f) {
            thrusterRatio = (float)Math.sqrt(thrusterRatio);
        }
        if (thrusterRatio > 6.0f) {
            thrusterRatio = (float)Math.sqrt(thrusterRatio) + 3.55f;
        }
        this.power = thrusterRatio;
        this.installed = EnumSet.copyOf(abilities);
        this.enabledSensors = DroneData.getInstalledSensors(this.installed);
    }

    public List<RecordedBlock> getBlocks() {
        return this.blocks;
    }

    public int getSize() {
        return this.size;
    }

    public float getRenderScale() {
        float defaultSize = 6.0f;
        return defaultSize / (float)this.size;
    }

    public boolean isGlowing() {
        return this.installed.contains((Object)DroneBehaviour.BlockFunctions.LIGHT);
    }

    public boolean isValid() {
        return this.power > 0.01f && !this.getBlocks().isEmpty();
    }

    public int getDroneId() {
        return this.droneId;
    }

    public Vec3i getAssemblerOffset() {
        return this.assemblerOffset;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DroneData droneData = (DroneData)o;
        return this.droneId == droneData.droneId;
    }

    public int hashCode() {
        return this.droneId;
    }

    private static List<DroneSensor> getInstalledSensors(EnumSet<DroneBehaviour.BlockFunctions> functions) {
        ArrayList<DroneSensor> sensors = new ArrayList<DroneSensor>();
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.BEAM)) {
            sensors.add(new BeamAttackBehaviour.BeamAttackSensor());
        }
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.ARROW_LAUNCHER)) {
            sensors.add(new ArrowAttackBehaviour.ArrowAttackSensor());
        }
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.MELEE_ATTACK)) {
            sensors.add(new MeleeAttackBehaviour.MeleeAttackSensor());
        }
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.PICKUP)) {
            sensors.add(new PickupBehaviour.PickupSensor());
        }
        return sensors;
    }

    private static float getThrust(RecordedBlock block, HashMap<Vec3i, BlockState> frame) {
        boolean blocked;
        boolean isThruster = block.state().is(TagContent.THRUSTER_BLOCKS);
        if (!isThruster) {
            return 0.0f;
        }
        boolean bl = blocked = frame.containsKey(block.localPos().below()) || frame.containsKey(block.localPos().below(2));
        if (blocked) {
            return 0.0f;
        }
        BlockState state = block.state();
        if (state.is(TagContent.LOW_THRUSTER)) {
            return 10.0f;
        }
        if (state.is(TagContent.MEDIUM_THRUSTER)) {
            return 25.0f;
        }
        if (state.is(TagContent.HIGH_THRUSTER)) {
            return 40.0f;
        }
        if (state.is(TagContent.ULTRA_THRUSTER)) {
            return 60.0f;
        }
        Drones.LOGGER.warn("Found thruster with thruster tag, but without a thrust strength tag: " + String.valueOf(state));
        return 0.0f;
    }
}

