/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.drone.DroneData;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.PlayerSwarmBehaviour;

public class DroneServerData {
    @NotNull
    public Vec3 currentPosition;
    @NotNull
    public Vec3 currentRotation;
    @NotNull
    public Vec3 targetPosition = Vec3.ZERO;
    @NotNull
    public Vec3 currentVelocity = Vec3.ZERO;
    @Nullable
    private DroneBehaviour currentTask = null;
    public int ghostTicks = 0;
    public int ghostWaitTime = 0;
    @NotNull
    public final DroneData droneData;

    public DroneServerData(DroneData droneData, ServerPlayer player) {
        this.droneData = droneData;
        this.currentPosition = player.getEyePosition();
        this.currentRotation = Vec3.ZERO;
        this.currentTask = new PlayerSwarmBehaviour(this, (Player)player);
    }

    @Nullable
    public DroneBehaviour getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(@Nullable DroneBehaviour currentTask) {
        if (this.currentTask != null) {
            this.currentTask.onStopped();
        }
        this.currentTask = currentTask;
    }
}

