/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class ArrowAttackBehaviour
extends PlayerSwarmBehaviour {
    private static final int MAX_RANGE = 25;
    public final LivingEntity target;
    public final Player owner;
    public final DroneServerData drone;
    private int attackCooldown = 0;

    public ArrowAttackBehaviour(LivingEntity target, Player owner, DroneServerData drone) {
        super(drone, owner);
        this.target = target;
        this.owner = owner;
        this.drone = drone;
    }

    @Override
    public void tick() {
        Vec3 shotFrom;
        double dist;
        super.tick();
        if (this.target.isRemoved() || !this.target.isAlive() || !this.target.isAttackable()) {
            this.finishTask();
        }
        if ((dist = (shotFrom = this.owner.getEyePosition().add(0.0, 1.2, 0.0)).distanceTo(this.target.getEyePosition())) > 25.0) {
            this.finishTask();
        }
        if (this.attackCooldown <= 0) {
            this.attackCooldown = this.getAttackCooldown();
            this.performAttack(dist, shotFrom);
        } else {
            --this.attackCooldown;
        }
    }

    public void performAttack(double dist, Vec3 shotFrom) {
        Level world = this.owner.level();
        ItemStack stack = new ItemStack((ItemLike)Items.ARROW);
        Vec3 targetPos = this.target.getEyePosition().add(0.0, dist / 10.0, 0.0);
        Vec3 offset = targetPos.subtract(shotFrom);
        Vec3 initialVelocity = offset.normalize().scale(2.0);
        Arrow arrowEntity = new Arrow(world, shotFrom.x, shotFrom.y, shotFrom.z, stack, null);
        arrowEntity.setDeltaMovement(initialVelocity);
        world.addFreshEntity((Entity)arrowEntity);
        Level level = this.owner.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            Vec3 forward = this.target.getEyePosition().subtract(this.drone.currentPosition).normalize();
            Vec3 particleStart = this.drone.currentPosition.add(forward.scale((double)0.3f));
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMALL_GUST, particleStart.x, particleStart.y, particleStart.z, 1, forward.x, forward.y, forward.z, (double)0.2f);
        }
    }

    public int getAttackCooldown() {
        return 24;
    }

    public void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public float getCurrentYaw() {
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.getEyePosition());
    }

    @Override
    public int getPriority() {
        return 55;
    }

    public static boolean isValid(RecordedBlock block, HashMap<Vec3i, BlockState> frame) {
        boolean blockMatches = block.state().is(TagContent.ARROW_LAUNCHER);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().south(i))) continue;
            return false;
        }
        return true;
    }

    public static class ArrowAttackSensor
    implements DroneSensor {
        @Override
        public int getPriority() {
            return 35;
        }

        @Override
        public boolean sense(DroneServerData drone, Player player) {
            Level world = player.level();
            int entityRange = this.getTargetingRange();
            Vec3 playerHead = player.getEyePosition();
            List<LivingEntity> targets = world.getEntitiesOfClass(LivingEntity.class, new AABB(playerHead.x - (double)entityRange, playerHead.y - (double)entityRange, playerHead.z - (double)entityRange, playerHead.x + (double)entityRange, playerHead.y + (double)entityRange, playerHead.z + (double)entityRange), EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(EntitySelector.NO_CREATIVE_OR_SPECTATOR));
            targets.sort(Comparator.comparingDouble(entity -> entity.distanceToSqr(playerHead)));
            targets = targets.stream().filter(target -> target.isAlive() && !target.isRemoved() && target instanceof Enemy).toList();
            if (!targets.isEmpty()) {
                this.onTargetFound(drone, player, targets.getFirst());
                return true;
            }
            return false;
        }

        public int getTargetingRange() {
            return 16;
        }

        public void onTargetFound(DroneServerData drone, Player player, LivingEntity target) {
            drone.setCurrentTask(new ArrowAttackBehaviour(target, player, drone));
        }
    }
}

