/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.ArrowAttackBehaviour;
import rearth.init.TagContent;

public class BeamAttackBehaviour
extends ArrowAttackBehaviour {
    private static final int ATTACK_DAMAGE = 10;

    public BeamAttackBehaviour(LivingEntity target, Player owner, DroneServerData drone) {
        super(target, owner, drone);
    }

    @Override
    public void performAttack(double dist, Vec3 shotFrom) {
        Level world = this.owner.level();
        this.target.hurt(new DamageSource((Holder)world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.PLAYER_ATTACK)), 10.0f);
        world.playSound(null, this.owner.blockPosition(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.PLAYERS, 0.5f, 1.7f);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.spawnBeamLine(this.drone.currentPosition, this.target.getEyePosition(), serverWorld);
        }
    }

    private void spawnBeamLine(Vec3 from, Vec3 to, ServerLevel world) {
        int count = (int)(from.distanceTo(to) * (double)0.6f + 1.0);
        count = Math.min(count, 12);
        Vec3 increment = to.subtract(from).scale((double)(1.0f / (float)count));
        SimpleParticleType particle = ParticleTypes.SONIC_BOOM;
        world.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, to.x, to.y, to.z, 1, 0.0, 0.0, 0.0, 0.0);
        int finalCount = count;
        CompletableFuture.runAsync(() -> {
            for (int i = 0; i < finalCount; ++i) {
                Vec3 pos = from.add(increment.scale((double)i));
                world.sendParticles((ParticleOptions)particle, pos.x(), pos.y(), pos.z(), 1, 0.0, 0.0, 0.0, 0.0);
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        });
    }

    @Override
    public int getAttackCooldown() {
        return 30;
    }

    public static boolean isValid(RecordedBlock block, HashMap<Vec3i, BlockState> frame) {
        boolean blockMatches = block.state().is(TagContent.BEAM_SOURCE);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().south(i))) continue;
            return false;
        }
        return true;
    }

    public static class BeamAttackSensor
    extends ArrowAttackBehaviour.ArrowAttackSensor {
        @Override
        public int getPriority() {
            return super.getPriority() + 2;
        }

        @Override
        public int getTargetingRange() {
            return super.getTargetingRange() + 8;
        }

        @Override
        public void onTargetFound(DroneServerData drone, Player player, LivingEntity target) {
            drone.setCurrentTask(new BeamAttackBehaviour(target, player, drone));
        }
    }
}

