/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import rearth.drone.DroneServerData;

public class DroneLight {
    private static final Map<GlobalPos, Long> activeLights = new HashMap<GlobalPos, Long>();
    private static final Map<DroneServerData, BlockPos> droneLights = new HashMap<DroneServerData, BlockPos>();

    public static void removeOldLights(Level world) {
        HashSet<GlobalPos> removed = new HashSet<GlobalPos>();
        for (Map.Entry<GlobalPos, Long> pair : activeLights.entrySet()) {
            if (pair.getValue() >= world.getGameTime() || !pair.getKey().dimension().equals(world.dimension())) continue;
            DroneLight.removeDroneLight(pair.getKey().pos(), world);
            removed.add(pair.getKey());
        }
        removed.forEach(activeLights::remove);
    }

    public static void updateDroneLight(DroneServerData drone, Level world) {
        BlockPos targetPos = BlockPos.containing((Position)drone.currentPosition);
        BlockPos lastPos = droneLights.get(drone);
        if (lastPos != null) {
            if (lastPos.equals((Object)targetPos)) {
                activeLights.put(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)targetPos), world.getGameTime() + 20L);
            } else {
                activeLights.remove(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)lastPos));
                DroneLight.removeDroneLight(lastPos, world);
                DroneLight.createDroneLight(drone, targetPos, world);
            }
        } else {
            DroneLight.createDroneLight(drone, targetPos, world);
        }
    }

    private static void removeDroneLight(BlockPos pos, Level world) {
        BlockState existingState = world.getBlockState(pos);
        if (!existingState.is(Blocks.LIGHT)) {
            return;
        }
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
    }

    private static void createDroneLight(DroneServerData data, BlockPos pos, Level world) {
        BlockState existingState = world.getBlockState(pos);
        if (!existingState.isAir()) {
            return;
        }
        world.setBlockAndUpdate(pos, Blocks.LIGHT.defaultBlockState());
        droneLights.put(data, pos);
        activeLights.put(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos), world.getGameTime() + 20L);
    }
}

