/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class MeleeAttackBehaviour
implements DroneBehaviour {
    private static final int MAX_RANGE = 25;
    private static final float HIT_RANGE = 1.25f;
    private static final int ATTACK_COOLDOWN = 21;
    private final LivingEntity target;
    private final Player owner;
    private final DroneServerData drone;
    private AttackPhase phase;
    private int attackCooldown = 0;

    public MeleeAttackBehaviour(LivingEntity target, Player owner, DroneServerData drone) {
        this.target = target;
        this.owner = owner;
        this.drone = drone;
        this.phase = AttackPhase.MOVING_IN;
    }

    @Override
    public void tick() {
        switch (this.phase.ordinal()) {
            case 0: {
                this.drone.targetPosition = this.target.getEyePosition();
                double dist = this.drone.currentPosition.distanceTo(this.target.getEyePosition());
                double playerDist = this.drone.currentPosition.distanceTo(this.owner.getEyePosition());
                this.attackCooldown = 0;
                if (dist > 25.0 || playerDist > 25.0) {
                    this.phase = AttackPhase.MOVING_HOME;
                    break;
                }
                if (!(dist < 1.25)) break;
                this.phase = AttackPhase.ATTACKING;
                break;
            }
            case 1: {
                double dist = this.drone.currentPosition.distanceTo(this.target.getEyePosition());
                if (dist > 2.5) {
                    this.phase = AttackPhase.MOVING_IN;
                    return;
                }
                if (!this.target.isAttackable() || !this.target.isAlive() || this.target.isRemoved()) {
                    this.phase = AttackPhase.MOVING_HOME;
                    return;
                }
                this.drone.targetPosition = this.target.getEyePosition();
                if (this.attackCooldown < 0) {
                    int damage = 2;
                    this.target.hurt(new DamageSource((Holder)this.owner.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.PLAYER_ATTACK), (Entity)this.owner), (float)damage);
                    this.attackCooldown = 21;
                    Level level = this.owner.level();
                    if (!(level instanceof ServerLevel)) break;
                    ServerLevel serverWorld = (ServerLevel)level;
                    Vec3 middle = this.drone.currentPosition.add(this.target.getEyePosition()).scale(0.5);
                    Vec3 forward = this.target.getEyePosition().subtract(this.drone.currentPosition).normalize();
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, middle.x, middle.y, middle.z, 1, forward.x, forward.y, forward.z, (double)0.2f);
                    break;
                }
                --this.attackCooldown;
                break;
            }
            case 2: {
                this.drone.targetPosition = this.owner.getEyePosition().add(0.0, 0.5, 0.0);
                double dist = this.drone.currentPosition.distanceTo(this.owner.getEyePosition());
                if (!(dist < 2.5)) break;
                this.finishTask();
            }
        }
    }

    public void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public float getCurrentYaw() {
        if (this.phase == AttackPhase.MOVING_HOME) {
            return Helpers.calculateYaw(this.drone.currentPosition, this.owner.getEyePosition());
        }
        if (this.phase == AttackPhase.ATTACKING) {
            float progress = (float)this.attackCooldown / 21.0f;
            return Helpers.calculateYaw(this.drone.currentPosition, this.target.getEyePosition()) + progress * 90.0f;
        }
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.getEyePosition());
    }

    @Override
    public float getExtraRoll() {
        if (this.phase == AttackPhase.ATTACKING) {
            long time = this.owner.level().getGameTime();
            return (float)(Math.sin((float)time / 2.0f) * 20.0);
        }
        return DroneBehaviour.super.getExtraRoll();
    }

    @Override
    public int getPriority() {
        return this.phase == AttackPhase.MOVING_HOME ? 3 : 80;
    }

    public static boolean isValid(RecordedBlock block, HashMap<Vec3i, BlockState> frame) {
        boolean blockMatches = block.state().is(TagContent.MELEE_DAMAGE);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().south(i))) continue;
            return false;
        }
        return true;
    }

    private static enum AttackPhase {
        MOVING_IN,
        ATTACKING,
        MOVING_HOME;

    }

    public static class MeleeAttackSensor
    implements DroneSensor {
        @Override
        public int getPriority() {
            return 40;
        }

        @Override
        public boolean sense(DroneServerData drone, Player player) {
            Level world = player.level();
            int entityRange = 16;
            Vec3 playerHead = player.getEyePosition();
            List<LivingEntity> targets = world.getEntitiesOfClass(LivingEntity.class, new AABB(playerHead.x - (double)entityRange, playerHead.y - (double)entityRange, playerHead.z - (double)entityRange, playerHead.x + (double)entityRange, playerHead.y + (double)entityRange, playerHead.z + (double)entityRange), EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(EntitySelector.NO_CREATIVE_OR_SPECTATOR));
            targets.sort(Comparator.comparingDouble(entity -> entity.distanceToSqr(playerHead)));
            targets = targets.stream().filter(target -> target.isAlive() && !target.isRemoved() && target instanceof Enemy).toList();
            if (!targets.isEmpty()) {
                drone.setCurrentTask(new MeleeAttackBehaviour(targets.getFirst(), player, drone));
                return true;
            }
            return false;
        }
    }
}

