/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rearth.Drones;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class MiningSupportBehaviour
implements DroneBehaviour {
    private static final int MAX_RANGE = 10;
    private static final float REACH = 0.6f;
    private static final int WAIT_TIME = 14;
    private final BlockPos target;
    private final Player owner;
    private final DroneServerData drone;
    private final BlockState startState;
    private SupportPhase phase;
    private int waitTicks;

    public MiningSupportBehaviour(BlockPos target, Player owner, DroneServerData drone) {
        this.target = target;
        this.owner = owner;
        this.drone = drone;
        this.phase = SupportPhase.MOVING_IN;
        this.startState = owner.level().getBlockState(target);
    }

    @Override
    public void tick() {
        if (!this.phase.equals((Object)SupportPhase.WAITING)) {
            if (!this.owner.level().getBlockState(this.target).equals(this.startState)) {
                this.finishMining();
                return;
            }
            Player player = this.owner;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos currentlyMiningPos = serverPlayer.gameMode.destroyPos;
                boolean stillMining = serverPlayer.gameMode.isDestroyingBlock;
                if (!currentlyMiningPos.equals((Object)this.target) || !stillMining) {
                    this.finishMining();
                    return;
                }
            }
        }
        switch (this.phase.ordinal()) {
            case 0: {
                this.drone.targetPosition = this.getTargetPosition();
                double ownerDist = this.owner.getEyePosition().distanceTo(this.drone.currentPosition);
                if (ownerDist > 10.0) {
                    this.finishTask();
                    return;
                }
                double targetDist = this.drone.currentPosition.distanceTo(this.drone.targetPosition);
                if (!(targetDist < (double)0.6f)) break;
                this.phase = SupportPhase.SUPPORTING;
                AttributeInstance miningInstance = this.owner.getAttribute(Attributes.BLOCK_BREAK_SPEED);
                if (miningInstance == null || miningInstance.hasModifier(Drones.id("drone_mine_bonus"))) break;
                miningInstance.addTransientModifier(new AttributeModifier(Drones.id("drone_mine_bonus"), 5.0, AttributeModifier.Operation.ADD_VALUE));
                break;
            }
            case 1: {
                this.drone.targetPosition = this.getTargetPosition();
                double ownerDist = this.owner.getEyePosition().distanceTo(this.drone.currentPosition);
                if (!(ownerDist > 10.0)) break;
                this.finishTask();
                break;
            }
            case 2: {
                --this.waitTicks;
                if (this.waitTicks > 0) break;
                this.finishTask();
            }
        }
    }

    private void finishMining() {
        this.phase = SupportPhase.WAITING;
        this.waitTicks = 14;
    }

    @Override
    public float getExtraRoll() {
        if (this.phase == SupportPhase.SUPPORTING) {
            long time = this.owner.level().getGameTime();
            return (float)(Math.sin((float)time / 2.0f) * 20.0);
        }
        return DroneBehaviour.super.getExtraRoll();
    }

    @Override
    public void onStopped() {
        Drones.DELAYED_ACTIONS.add(() -> {
            AttributeInstance miningInstance = this.owner.getAttribute(Attributes.BLOCK_BREAK_SPEED);
            if (miningInstance != null) {
                miningInstance.removeModifier(Drones.id("drone_mine_bonus"));
            }
        });
    }

    public void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public float getCurrentYaw() {
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.getCenter());
    }

    @Override
    public int getPriority() {
        return this.phase == SupportPhase.WAITING ? 3 : 20;
    }

    private Vec3 getTargetPosition() {
        Vec3 playerPos = this.owner.getEyePosition();
        Vec3 blockCenter = this.target.getCenter();
        Vec3 playerDir = blockCenter.subtract(playerPos).normalize();
        Vec3 playerUp = new Vec3(0.0, 1.0, 0.0);
        Vec3 sideDirection = playerDir.cross(playerUp);
        Vec3 otherSideDirection = sideDirection.scale(-1.0);
        Vec3 potentialPosA = blockCenter.add(sideDirection).add(playerDir.scale(-1.0));
        Vec3 potentialPosB = blockCenter.add(otherSideDirection).add(playerDir.scale(-1.0));
        Vec3 potentialPosC = blockCenter.add(playerDir.scale(-2.0)).add(0.0, -0.6, 0.0);
        if (Helpers.isPositionAvailable(this.owner.level(), potentialPosA, playerPos)) {
            return potentialPosA;
        }
        if (Helpers.isPositionAvailable(this.owner.level(), potentialPosB, playerPos)) {
            return potentialPosB;
        }
        return potentialPosC;
    }

    public static boolean isValidMiningTarget(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return !state.isAir() && !state.liquid() && state.getDestroySpeed((BlockGetter)world, pos) > 0.1f;
    }

    public static boolean isValid(RecordedBlock block, HashMap<Vec3i, BlockState> frame) {
        boolean blockMatches = block.state().is(TagContent.MINING_TOOLS);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().south(i))) continue;
            return false;
        }
        return true;
    }

    private static enum SupportPhase {
        MOVING_IN,
        SUPPORTING,
        WAITING;

    }
}

