/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class PickupBehaviour
implements DroneBehaviour {
    private static final int MAX_RANGE = 25;
    private static final float PICKUP_RANGE = 0.75f;
    private final Player owner;
    private final DroneServerData drone;
    private final ItemEntity target;
    private PickupPhase phase;
    private boolean collected = false;

    public PickupBehaviour(Player owner, DroneServerData drone, ItemEntity target) {
        this.owner = owner;
        this.drone = drone;
        this.target = target;
        this.phase = PickupPhase.MOVING_IN;
    }

    @Override
    public void tick() {
        switch (this.phase.ordinal()) {
            case 0: {
                this.drone.targetPosition = this.target.getEyePosition();
                double playerDist = this.drone.currentPosition.distanceTo(this.owner.getEyePosition());
                double targetDist = this.drone.currentPosition.distanceTo(this.target.getEyePosition());
                if (playerDist > 25.0 || this.target.isRemoved()) {
                    this.phase = PickupPhase.MOVING_HOME;
                }
                if (!(targetDist < 0.75)) break;
                this.phase = PickupPhase.MOVING_HOME;
                this.collected = true;
                this.target.setNoGravity(true);
                break;
            }
            case 1: {
                double playerDist;
                this.drone.targetPosition = this.owner.getEyePosition().add(0.0, 0.7, 0.0);
                if (this.collected && !this.target.isRemoved()) {
                    this.target.setPos(this.drone.currentPosition);
                }
                if (!((playerDist = this.drone.currentPosition.distanceTo(this.owner.getEyePosition())) < 1.0)) break;
                this.finishTask();
            }
        }
    }

    private void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public void onStopped() {
        if (this.collected && !this.target.isRemoved()) {
            this.target.setNoGravity(true);
        }
    }

    @Override
    public float getCurrentYaw() {
        if (this.phase == PickupPhase.MOVING_HOME) {
            return Helpers.calculateYaw(this.drone.currentPosition, this.owner.getEyePosition());
        }
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.getEyePosition());
    }

    @Override
    public int getPriority() {
        return 10;
    }

    public static Optional<ItemEntity> GetPickupTarget(Player player) {
        Level world = player.level();
        Vec3 target = player.getEyePosition();
        int range = 12;
        AABB box = new AABB(target.x - (double)range, target.y - (double)range, target.z - (double)range, target.x + (double)range, target.y + (double)range, target.z + (double)range);
        List items = world.getEntitiesOfClass(ItemEntity.class, box, itemEntity -> !itemEntity.hasPickUpDelay());
        if (!items.isEmpty()) {
            return Optional.of((ItemEntity)items.getFirst());
        }
        return Optional.empty();
    }

    public static boolean isValid(RecordedBlock block, HashMap<Vec3i, BlockState> frame) {
        boolean blockMatches = block.state().is(TagContent.PICKUP_TOOLS);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().below(i))) continue;
            return false;
        }
        return true;
    }

    private static enum PickupPhase {
        MOVING_IN,
        MOVING_HOME;

    }

    public static class PickupSensor
    implements DroneSensor {
        @Override
        public int getPriority() {
            return 10;
        }

        @Override
        public boolean sense(DroneServerData drone, Player player) {
            Optional<ItemEntity> candidate = PickupBehaviour.GetPickupTarget(player);
            if (candidate.isPresent()) {
                drone.setCurrentTask(new PickupBehaviour(player, drone, candidate.get()));
                return true;
            }
            return false;
        }
    }
}

