/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import rearth.drone.DroneController;
import rearth.drone.DroneServerData;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.util.Helpers;

public class PlayerSwarmBehaviour
implements DroneBehaviour {
    private final DroneServerData drone;
    private final Player owner;

    public PlayerSwarmBehaviour(DroneServerData drone, Player owner) {
        this.drone = drone;
        this.owner = owner;
    }

    @Override
    public void tick() {
        if (this.owner.isRemoved()) {
            this.drone.setCurrentTask(null);
        }
        this.drone.targetPosition = PlayerSwarmBehaviour.getIdlePositionTarget(this.owner);
    }

    @Override
    public float getCurrentYaw() {
        double playerDist = this.drone.currentPosition.distanceTo(this.owner.getEyePosition());
        if (playerDist > 5.0) {
            return Helpers.calculateYaw(this.drone.currentPosition, this.owner.getEyePosition());
        }
        return this.owner.yHeadRot;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public static Vec3 getIdlePositionTarget(Player player) {
        Vec3 playerHead = player.getEyePosition();
        Vec3 overheadCenter = playerHead.add(0.0, 0.5, 0.0);
        double playerYaw = Math.toRadians(player.yBodyRot - 90.0f);
        Vec3 playerBackDir = new Vec3(Math.cos(playerYaw), 0.0, Math.sin(playerYaw)).normalize();
        long time = player.level().getGameTime();
        float sampledX = (float)time / 100.0f;
        double x = DroneController.SIMPLEX.getValue((double)sampledX, 0.0);
        double y = DroneController.SIMPLEX.getValue((double)sampledX, 5000.0);
        double z = DroneController.SIMPLEX.getValue((double)(sampledX + 5000.0f), 5000.0);
        Vec3 offset = new Vec3(x, y / 3.0, z);
        return overheadCenter.add(offset.scale(1.0)).add(playerBackDir.scale((double)0.9f));
    }
}

