/*
 * Decompiled with CFR 0.152.
 */
package rearth.init;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import rearth.Drones;
import rearth.blocks.controller.ControllerBlock;
import rearth.blocks.rotors.DrillBlock;
import rearth.blocks.rotors.IonThruster;
import rearth.blocks.rotors.IronRotor;
import rearth.blocks.rotors.WoodenRotor;
import rearth.init.ItemContent;
import rearth.init.ItemGroups;

public class BlockContent {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"drones", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<Block> ASSEMBLER_FRAME = BLOCKS.register("frame", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> ASSEMBLER_CONTROLLER = BLOCKS.register("controller", () -> new ControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> WOOD_ROTOR = BLOCKS.register("wood_rotor", () -> new WoodenRotor(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion()));
    public static final RegistrySupplier<Block> IRON_ROTOR = BLOCKS.register("iron_rotor", () -> new IronRotor(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion()));
    public static final RegistrySupplier<Block> ION_THRUSTER = BLOCKS.register("ion_thruster", () -> new IonThruster(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion()));
    public static final RegistrySupplier<Block> DRILL = BLOCKS.register("drill", () -> new DrillBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).noOcclusion()));

    public static void registerItems() {
        BlockContent.registerItem(ASSEMBLER_FRAME, "frame");
        BlockContent.registerItem(ASSEMBLER_CONTROLLER, "controller");
        BlockContent.registerItem(WOOD_ROTOR, "wood_rotor");
        BlockContent.registerItem(IRON_ROTOR, "iron_rotor");
        BlockContent.registerItem(ION_THRUSTER, "ion_thruster");
        BlockContent.registerItem(DRILL, "drill");
    }

    private static void registerItem(RegistrySupplier<Block> block, String name) {
        ItemContent.ITEMS.register(Drones.id(name), () -> new BlockItem((Block)block.get(), new Item.Properties().arch$tab(ItemGroups.DRONES_TAB)));
    }
}

