/*
 * Decompiled with CFR 0.152.
 */
package rearth.init;

import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import rearth.Drones;
import rearth.DronesClient;
import rearth.blocks.controller.ControllerBlockEntity;
import rearth.init.BlockEntitiesContent;
import rearth.util.Helpers;

public class NetworkContent {
    public static void init() {
        NetworkContent.registerS2C(DroneMoveSyncPacket.PAYLOAD_ID, DroneMoveSyncPacket.PACKET_CODEC, (value, context) -> DronesClient.CURRENT_DATA.put(value.droneId(), (DroneMoveSyncPacket)value));
        if (Platform.getEnvironment().equals((Object)Env.SERVER)) {
            NetworkAggregator.registerS2CType(OpenDroneScreenPacket.PAYLOAD_ID, OpenDroneScreenPacket.PACKET_CODEC, List.of());
        }
        NetworkContent.registerC2S(ControllerBlockEntity.AssembleDronePacket.PAYLOAD_ID, ControllerBlockEntity.AssembleDronePacket.PACKET_CODEC, (value, context) -> {
            Level world = context.getPlayer().level();
            Player player = context.getPlayer();
            Optional candidate = world.getBlockEntity(value.controllerPos(), (BlockEntityType)BlockEntitiesContent.ASSEMBLER_CONTROLLER.get());
            candidate.ifPresent(controllerBlockEntity -> controllerBlockEntity.assembleDrone(player, value.name()));
        });
    }

    private static <T extends CustomPacketPayload> void registerS2C(CustomPacketPayload.Type<T> dataPayloadId, StreamCodec<ByteBuf, T> packetCodec, NetworkManager.NetworkReceiver<T> receiver) {
        if (Platform.getEnvironment().equals((Object)Env.SERVER)) {
            NetworkAggregator.registerS2CType(dataPayloadId, packetCodec, List.of());
        } else {
            NetworkAggregator.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, dataPayloadId, packetCodec, List.of(), receiver);
        }
    }

    private static <T extends CustomPacketPayload> void registerC2S(CustomPacketPayload.Type<T> dataPayloadId, StreamCodec<ByteBuf, T> packetCodec, NetworkManager.NetworkReceiver<T> receiver) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, dataPayloadId, packetCodec, receiver);
    }

    public record DroneMoveSyncPacket(Vec3 position, Vec3 rotation, int droneId) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<DroneMoveSyncPacket> PAYLOAD_ID = new CustomPacketPayload.Type(Drones.id("move"));
        public static final StreamCodec<ByteBuf, DroneMoveSyncPacket> PACKET_CODEC = StreamCodec.composite(Helpers.VEC3D_PACKET_CODEC, DroneMoveSyncPacket::position, Helpers.VEC3D_PACKET_CODEC, DroneMoveSyncPacket::rotation, (StreamCodec)ByteBufCodecs.INT, DroneMoveSyncPacket::droneId, DroneMoveSyncPacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PAYLOAD_ID;
        }
    }

    public record OpenDroneScreenPacket(BlockPos controllerPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenDroneScreenPacket> PAYLOAD_ID = new CustomPacketPayload.Type(Drones.id("open_screen"));
        public static final StreamCodec<ByteBuf, OpenDroneScreenPacket> PACKET_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, OpenDroneScreenPacket::controllerPos, OpenDroneScreenPacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PAYLOAD_ID;
        }
    }
}

