/*
 * Decompiled with CFR 0.152.
 */
package rearth.items;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import rearth.drone.DroneData;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.init.ComponentContent;

public class PocketDrone
extends Item
implements Equipable {
    public PocketDrone(Item.Properties settings) {
        super(settings);
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (!stack.has((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get())) {
            super.appendHoverText(stack, context, tooltip, type);
            return;
        }
        DroneData data = (DroneData)stack.get((DataComponentType)ComponentContent.DRONE_DATA_TYPE.get());
        String speed = String.format("%.1f", Float.valueOf(data.power));
        int blocks = data.getBlocks().size();
        EnumSet<DroneBehaviour.BlockFunctions> abilities = data.installed;
        int size = data.getSize();
        tooltip.add((Component)Component.translatable((String)"tooltip.drones.data_speed", (Object[])new Object[]{speed}));
        tooltip.add((Component)Component.translatable((String)"tooltip.drones.block_count", (Object[])new Object[]{blocks}));
        tooltip.add((Component)Component.translatable((String)"tooltip.drones.data_size", (Object[])new Object[]{size}));
        tooltip.add((Component)Component.translatable((String)"tooltip.drones.abilities_heading"));
        for (DroneBehaviour.BlockFunctions ability : abilities) {
            tooltip.add((Component)Component.literal((String)" - ").append((Component)Component.translatable((String)("drones.ability." + ability.name().toLowerCase()))).withStyle(ChatFormatting.ITALIC));
        }
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"tooltip.drones.equip_hint").withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        super.appendHoverText(stack, context, tooltip, type);
    }
}

