/*
 * Decompiled with CFR 0.152.
 */
package rearth.neoforge.client;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import rearth.DronesClient;
import rearth.client.renderers.DroneRenderer;

@Mod(value="drones", dist={Dist.CLIENT})
public class DronesModNeoForgeClient {
    public DronesModNeoForgeClient(IEventBus eventBus) {
        DronesClient.init();
        eventBus.register((Object)new EventHandler());
    }

    static class EventHandler {
        EventHandler() {
        }

        @SubscribeEvent
        public void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            for (Map.Entry<Supplier<Block>, RenderType> entry : DronesClient.RENDER_LAYERS.entrySet()) {
                ItemBlockRenderTypes.setRenderLayer((Block)entry.getKey().get(), (RenderType)entry.getValue());
            }
        }
    }

    @EventBusSubscriber(modid="drones", value={Dist.CLIENT})
    public static class CustomEvents {
        @SubscribeEvent
        public static void onWorldRender(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                DroneRenderer.doRender(event.getPoseStack(), event.getCamera(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource());
            }
        }
    }
}

