/*
 * Decompiled with CFR 0.152.
 */
package rearth.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class Helpers {
    public static StreamCodec<ByteBuf, Vec3i> VEC3I_PACKET_CODEC = new StreamCodec<ByteBuf, Vec3i>(){

        public Vec3i decode(ByteBuf buf) {
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            return new Vec3i(x, y, z);
        }

        public void encode(ByteBuf buf, Vec3i value) {
            buf.writeInt(value.getX());
            buf.writeInt(value.getY());
            buf.writeInt(value.getZ());
        }
    };
    public static StreamCodec<ByteBuf, Vec3> VEC3D_PACKET_CODEC = new StreamCodec<ByteBuf, Vec3>(){

        public Vec3 decode(ByteBuf buf) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            return new Vec3(x, y, z);
        }

        public void encode(ByteBuf buf, Vec3 value) {
            buf.writeDouble(value.x);
            buf.writeDouble(value.y);
            buf.writeDouble(value.z);
        }
    };

    public static float calculateYaw(Vec3 self, Vec3 target) {
        Vec3 direction = target.subtract(self).normalize();
        return (float)Math.toDegrees(Math.atan2(direction.z, direction.x)) - 90.0f;
    }

    public static Vec3 lerp(Vec3 a, Vec3 b, float f) {
        return new Vec3(Helpers.lerp(a.x, b.x, (double)f), Helpers.lerp(a.y, b.y, (double)(f / 2.0f)), Helpers.lerp(a.z, b.z, (double)f));
    }

    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    public static boolean isLineAvailable(Level world, Vec3 to, Vec3 from) {
        ClipContext context = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
        BlockHitResult result = world.clip(context);
        return result == null || !result.isInside();
    }

    public static boolean isPositionAvailable(Level world, Vec3 pos, Vec3 from) {
        Vec3 backDir = from.subtract(pos).normalize();
        Vec3 start = pos.add(backDir.scale(0.5));
        ClipContext context = new ClipContext(start, pos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty());
        BlockHitResult result = world.clip(context);
        return result == null || !result.isInside();
    }
}

