/*
 * Decompiled with CFR 0.152.
 */
package rearth.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_8710;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import rearth.Drones;
import rearth.blocks.controller.ControllerBlockEntity;
import rearth.drone.DroneData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;

public class DroneCreatorScreen
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = Drones.id("textures/gui/assembler.png");
    private static final class_2960 BIG_BUTTON_TEXTURE = Drones.id("textures/gui/big_button.png");
    private static final class_2960 BIG_BUTTON_HOVER_TEXTURE = Drones.id("textures/gui/big_button_hover.png");
    private static final class_2960 BIG_BUTTON_PRESSED_TEXTURE = Drones.id("textures/gui/big_button_pressed.png");
    private static final class_2960 SLOT_PANEL_TEXTURE = Drones.id("textures/gui/slot_panel.png");
    private final DroneData droneData;
    private final HashMap<class_2382, class_2586> renderedEntities = new HashMap();
    private float openTime = 0.0f;
    private final class_2338 machinePos;
    private float previewAngle = 0.0f;
    private class_342 nameField;

    public DroneCreatorScreen(DroneData data, class_2338 machinePos) {
        super((class_2561)class_2561.method_43473());
        this.machinePos = machinePos;
        if (data == null) {
            data = new DroneData(List.of(), 1, class_2382.field_11176);
        }
        this.droneData = data;
        for (RecordedBlock pair : this.droneData.getBlocks()) {
            class_2343 blockEntityProvider;
            class_2586 blockEntity;
            class_2680 state = pair.state();
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof class_2343) || (blockEntity = (blockEntityProvider = (class_2343)class_22482).method_10123(new class_2338(pair.localPos()), state)) == null || this.field_22787 == null) continue;
            blockEntity.method_31662((class_1937)this.field_22787.field_1687);
            class_827 renderer = class_310.method_1551().method_31975().method_3550(blockEntity);
            if (renderer == null) continue;
            this.renderedEntities.put(pair.localPos(), blockEntity);
        }
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int backgroundStartX = centerX - 150;
        int backgroundStartY = centerY - 91;
        int buttonX = backgroundStartX + 154;
        int buttonY = backgroundStartY + 113;
        int nameX = backgroundStartX + 7;
        int nameY = backgroundStartY + 140;
        BigDroneButton buttonWidget = new BigDroneButton(buttonX, buttonY, 138, 59, (class_2561)class_2561.method_43470((String)"BUILD!").method_27692(class_124.field_1067), button -> {}, this);
        this.method_37063((class_364)buttonWidget);
        this.nameField = new class_342(this.field_22793, nameX, nameY, 138, 32, (class_2561)class_2561.method_43470((String)"Input"));
        this.nameField.method_1880(32);
        this.nameField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.drones.name_field")));
        this.nameField.method_1852("Dronie");
        this.method_37063((class_364)this.nameField);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        int textColor = 13685204;
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int backgroundStartX = centerX - 150;
        int backgroundStartY = centerY - 91;
        context.method_25291(BACKGROUND_TEXTURE, backgroundStartX, backgroundStartY, 0, 0.0f, 0.0f, 300, 183, 300, 183);
        for (RecordedBlock pair : this.droneData.getBlocks()) {
            class_2586 entity = this.renderedEntities.get(pair.localPos());
            this.renderBlock(context, pair.localPos(), pair.state(), entity, delta);
        }
        for (class_4068 drawable : this.field_33816) {
            drawable.method_25394(context, mouseX, mouseY, delta);
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Speed:"), backgroundStartX + 161, backgroundStartY + 13, textColor, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"Size:"), backgroundStartX + 161, backgroundStartY + 44, textColor, false);
        int greenColor = -12810969;
        int orangeColor = -1012726;
        int markerColor = -3092012;
        int endColor = -526345;
        float speedBarFill = this.getSpeedProgress();
        int speedColor = (double)speedBarFill > 0.25 ? greenColor : orangeColor;
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.0f, speedBarFill, speedColor, 5, 0);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.248f, 0.252f, markerColor, 3, 1);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.498f, 0.502f, markerColor, 3, 1);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.748f, 0.752f, markerColor, 3, 1);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, speedBarFill - 0.005f, speedBarFill + 0.005f, endColor, 5, 0);
        float sizeBarFill = this.getSizeProgress();
        int sizeColor = (double)sizeBarFill < 0.75 ? greenColor : orangeColor;
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.0f, sizeBarFill, sizeColor, 5, 32);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.248f, 0.252f, markerColor, 3, 33);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.498f, 0.502f, markerColor, 3, 33);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, 0.748f, 0.752f, markerColor, 3, 33);
        this.drawBarPart(context, backgroundStartX, backgroundStartY, sizeBarFill - 0.005f, sizeBarFill + 0.005f, endColor, 5, 32);
        int abilitiesStartX = backgroundStartX + 159;
        int abilitiesStartY = backgroundStartY + 80;
        int index = 0;
        for (DroneBehaviour.BlockFunctions ability : this.droneData.installed) {
            boolean isHovered;
            if (ability.equals((Object)DroneBehaviour.BlockFunctions.FLIGHT)) continue;
            int startAtX = abilitiesStartX + index * 23;
            context.method_25291(SLOT_PANEL_TEXTURE, startAtX, abilitiesStartY, 0, 0.0f, 0.0f, 20, 20, 20, 20);
            boolean bl = isHovered = mouseX > startAtX && mouseX < startAtX + 20 && mouseY > abilitiesStartY && mouseY < abilitiesStartY + 20;
            if (isHovered) {
                context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)("drones.ability." + ability.name().toLowerCase())), startAtX, abilitiesStartY + 40);
                for (int i = 0; i < 5; ++i) {
                    String tooltipKey = "drones.ability." + ability.name().toLowerCase() + "." + i;
                    if (!class_1074.method_4663((String)tooltipKey)) continue;
                    context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)tooltipKey), startAtX, abilitiesStartY + 40 + 11 + i * 10);
                }
            }
            class_1792 renderedItem = DroneBehaviour.getItem(ability);
            DroneCreatorScreen.drawItem(context, renderedItem, startAtX + 2, abilitiesStartY + 2, 16);
            ++index;
        }
        if (index == 0) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)"No Abilities"), abilitiesStartX + 5, abilitiesStartY + 7, textColor, false);
        }
        this.openTime += delta;
    }

    private void drawBarPart(class_332 context, int backgroundStartX, int backgroundStartY, float fillStart, float fillEnd, int color, int height, int yOffset) {
        int speedFromX = backgroundStartX + 161 + (int)(124.0f * fillStart);
        int speedFromY = backgroundStartY + 26 + yOffset;
        int speedToX = backgroundStartX + 161 + (int)(124.0f * fillEnd);
        int speedToY = speedFromY + height;
        context.method_51737(speedFromX, speedFromY, speedToX, speedToY, 10, color);
    }

    private void renderBlock(class_332 context, class_2382 offset, class_2680 state, @Nullable class_2586 entity, float partialTicks) {
        int x = this.field_22789 / 2 - 150 + 70;
        int y = this.field_22790 / 2 - 30;
        int size = 20;
        float rotation = this.openTime * 2.0f % 360.0f;
        float scale = this.droneData.getRenderScale();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, 400.0f);
        context.method_51448().method_22905((float)(40 * size) / 64.0f, (float)(-40 * size) / 64.0f, 40.0f);
        context.method_51448().method_22905(scale, scale, scale);
        context.method_51448().method_22907(class_7833.field_40714.rotationDegrees(30.0f + this.previewAngle));
        context.method_51448().method_22907(class_7833.field_40716.rotationDegrees(225.0f + rotation));
        context.method_51448().method_22904(-0.5 + (double)offset.method_10263(), -0.5 + (double)offset.method_10264(), -0.5 + (double)offset.method_10260());
        RenderSystem.runAsFancy(() -> {
            class_827 entityRenderer;
            class_4597.class_4598 vertexConsumers = this.field_22787.method_22940().method_23000();
            if (state.method_26217() != class_2464.field_11456) {
                this.field_22787.method_1541().method_3353(state, context.method_51448(), (class_4597)vertexConsumers, 0xF000F0, class_4608.field_21444);
            }
            if (entity != null && (entityRenderer = this.field_22787.method_31975().method_3550(entity)) != null) {
                entityRenderer.method_3569(entity, partialTicks, context.method_51448(), (class_4597)vertexConsumers, 0xF000F0, class_4608.field_21444);
            }
            RenderSystem.setShaderLights((Vector3f)new Vector3f(-1.5f, -0.5f, 0.0f), (Vector3f)new Vector3f(0.0f, -1.0f, 0.0f));
            vertexConsumers.method_22993();
            class_308.method_24211();
        });
        context.method_51448().method_22909();
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (Math.abs(deltaY) > 0.001) {
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            int backgroundStartX = centerX - 150;
            int backgroundStartY = centerY - 91;
            int previewStartX = backgroundStartX + 5;
            int previewEndX = previewStartX + 140;
            int previewStartY = backgroundStartY + 5;
            int previewEndY = previewStartY + 170;
            if (mouseX < (double)previewEndX && mouseX > (double)previewStartX && mouseY < (double)previewEndY && mouseY > (double)previewStartY) {
                this.previewAngle = (float)((double)this.previewAngle + deltaY);
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private float getSpeedProgress() {
        return Math.clamp(this.droneData.power / 10.0f, 0.01f, 1.0f);
    }

    private float getSizeProgress() {
        return Math.clamp((float)this.droneData.getSize() / 10.0f, 0.1f, 1.0f);
    }

    private static void drawItem(class_332 context, class_1792 item, int x, int y, int size) {
        boolean notSideLit;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_4597.class_4598 entityBuffers = class_310.method_1551().method_22940().method_23000();
        class_1799 stack = new class_1799((class_1935)item);
        boolean bl = notSideLit = !itemRenderer.method_4019(stack, null, null, 0).method_24304();
        if (notSideLit) {
            class_308.method_24210();
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 100.0f);
        matrices.method_22905((float)size / 16.0f, (float)size / 16.0f, 1.0f);
        matrices.method_22904(8.0, 8.0, 0.0);
        if (notSideLit) {
            matrices.method_22905(16.0f, -16.0f, 16.0f);
        } else {
            matrices.method_34425(new Matrix4f().scaling(16.0f, -16.0f, 16.0f));
        }
        class_310 client = class_310.method_1551();
        itemRenderer.method_23178(stack, class_811.field_4317, 0xF000F0, class_4608.field_21444, matrices, (class_4597)entityBuffers, (class_1937)client.field_1687, 0);
        entityBuffers.method_22993();
        matrices.method_22909();
        if (notSideLit) {
            class_308.method_24211();
        }
    }

    public void assembleDrone() {
        if (!this.droneData.isValid()) {
            this.field_22787.method_1566().method_1999((class_368)class_370.method_29047((class_310)this.field_22787, (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43471((String)"drone.message.invalid_drone"), (class_2561)class_2561.method_43471((String)"drone.message.invalid_drone_desc")));
            return;
        }
        this.field_22787.method_1566().method_1999((class_368)class_370.method_29047((class_310)this.field_22787, (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43471((String)"drone.message.assembled"), (class_2561)class_2561.method_43471((String)"drone.message.assembled_desc")));
        NetworkManager.sendToServer((class_8710)new ControllerBlockEntity.AssembleDronePacket(this.nameField.method_1882(), this.machinePos));
        this.method_25419();
    }

    private static class BigDroneButton
    extends class_4185 {
        private boolean isPressed = false;
        private final DroneCreatorScreen parent;

        protected BigDroneButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress, DroneCreatorScreen parent) {
            super(x, y, width, height, message, onPress, class_4185.field_40754);
            this.parent = parent;
        }

        public void method_25306() {
            this.isPressed = true;
            super.method_25306();
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            boolean valid = super.method_25406(mouseX, mouseY, button);
            if (valid && this.isPressed) {
                this.isPressed = false;
                this.parent.assembleDrone();
                this.playUpSound(class_310.method_1551().method_1483());
            }
            return valid;
        }

        public void method_25354(class_1144 soundManager) {
            soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_40094, (float)0.7f));
        }

        public void playUpSound(class_1144 soundManager) {
            soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_19344, (float)0.7f));
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_2960 usedTexture = BIG_BUTTON_TEXTURE;
            if (this.method_49606()) {
                usedTexture = BIG_BUTTON_HOVER_TEXTURE;
            }
            if (this.isPressed) {
                usedTexture = BIG_BUTTON_PRESSED_TEXTURE;
            }
            context.method_25291(usedTexture, this.method_46426(), this.method_46427(), 0, 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
            float scale = 3.4f;
            int textX = this.method_46426() + 11;
            int textY = this.method_46427() + 13;
            int textColor = 13685204;
            if (this.method_49606()) {
                textY += 4;
            }
            if (this.isPressed) {
                textY += 6;
            }
            context.method_51448().method_22903();
            context.method_51448().method_22905(scale, scale, scale);
            textX = (int)((float)textX / scale);
            textY = (int)((float)textY / scale);
            context.method_51439(class_310.method_1551().field_1772, this.method_25369(), textX, textY, textColor, false);
            context.method_51448().method_22909();
        }
    }
}

