/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import rearth.Drones;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.ArrowAttackBehaviour;
import rearth.drone.behaviour.BeamAttackBehaviour;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.MeleeAttackBehaviour;
import rearth.drone.behaviour.MiningSupportBehaviour;
import rearth.drone.behaviour.PickupBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class DroneData {
    private final List<RecordedBlock> blocks;
    private final int size;
    private final int droneId;
    private final class_2382 assemblerOffset;
    public final EnumSet<DroneBehaviour.BlockFunctions> installed;
    public final float power;
    public final List<DroneSensor> enabledSensors;
    public static class_9139<ByteBuf, DroneData> PACKET_CODEC = class_9139.method_56436((class_9139)RecordedBlock.PACKET_CODEC.method_56433(class_9135.method_56363()), DroneData::getBlocks, (class_9139)class_9135.field_49675, DroneData::getDroneId, Helpers.VEC3I_PACKET_CODEC, DroneData::getAssemblerOffset, DroneData::new);
    public static Codec<DroneData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RecordedBlock.CODEC.listOf().fieldOf("blocks").forGetter(DroneData::getBlocks), (App)class_5699.field_33442.fieldOf("id").forGetter(DroneData::getDroneId), (App)class_2382.field_25123.fieldOf("offset").forGetter(DroneData::getAssemblerOffset)).apply((Applicative)instance, DroneData::new));

    public DroneData(@NotNull List<RecordedBlock> blocks, int id, class_2382 assemblerOffset) {
        this.blocks = blocks;
        this.droneId = id;
        this.assemblerOffset = assemblerOffset;
        float weight = 0.0f;
        float thrust = 0.0f;
        ArrayList<DroneBehaviour.BlockFunctions> abilities = new ArrayList<DroneBehaviour.BlockFunctions>();
        abilities.add(DroneBehaviour.BlockFunctions.FLIGHT);
        boolean light = false;
        HashMap<class_2382, class_2680> droneFrame = new HashMap<class_2382, class_2680>();
        blocks.forEach(block -> droneFrame.put(block.localPos(), block.state()));
        int minX = 0;
        int minZ = 0;
        int maxX = 0;
        int maxZ = 0;
        for (RecordedBlock recordedBlock : blocks) {
            class_2382 localPos;
            class_2680 state = recordedBlock.state();
            weight += state.method_26204().method_36555();
            thrust += DroneData.getThrust(recordedBlock, droneFrame);
            if (ArrowAttackBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.ARROW_LAUNCHER);
            }
            if (MeleeAttackBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.MELEE_ATTACK);
            }
            if (MiningSupportBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.MINING_SUPPORT);
            }
            if (PickupBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.PICKUP);
            }
            if (BeamAttackBehaviour.isValid(recordedBlock, droneFrame)) {
                abilities.add(DroneBehaviour.BlockFunctions.BEAM);
            }
            if (state.method_26213() > 5) {
                abilities.add(DroneBehaviour.BlockFunctions.LIGHT);
            }
            if ((localPos = recordedBlock.localPos()).method_10263() < minX) {
                minX = localPos.method_10263();
            }
            if (localPos.method_10260() < minZ) {
                minZ = localPos.method_10260();
            }
            if (localPos.method_10263() > maxX) {
                maxX = localPos.method_10263();
            }
            if (localPos.method_10260() <= maxZ) continue;
            maxZ = localPos.method_10260();
        }
        int sizeX = maxX - minX + 1;
        int sizeZ = maxZ - minZ + 1;
        this.size = Math.max(sizeX, sizeZ);
        float thrusterRatio = thrust / weight;
        if (thrusterRatio < 1.0f) {
            thrusterRatio = (float)Math.sqrt(thrusterRatio);
        }
        if (thrusterRatio > 6.0f) {
            thrusterRatio = (float)Math.sqrt(thrusterRatio) + 3.55f;
        }
        this.power = thrusterRatio;
        this.installed = EnumSet.copyOf(abilities);
        this.enabledSensors = DroneData.getInstalledSensors(this.installed);
    }

    public List<RecordedBlock> getBlocks() {
        return this.blocks;
    }

    public int getSize() {
        return this.size;
    }

    public float getRenderScale() {
        float defaultSize = 6.0f;
        return defaultSize / (float)this.size;
    }

    public boolean isGlowing() {
        return this.installed.contains((Object)DroneBehaviour.BlockFunctions.LIGHT);
    }

    public boolean isValid() {
        return this.power > 0.01f && !this.getBlocks().isEmpty();
    }

    public int getDroneId() {
        return this.droneId;
    }

    public class_2382 getAssemblerOffset() {
        return this.assemblerOffset;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DroneData droneData = (DroneData)o;
        return this.droneId == droneData.droneId;
    }

    public int hashCode() {
        return this.droneId;
    }

    private static List<DroneSensor> getInstalledSensors(EnumSet<DroneBehaviour.BlockFunctions> functions) {
        ArrayList<DroneSensor> sensors = new ArrayList<DroneSensor>();
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.BEAM)) {
            sensors.add(new BeamAttackBehaviour.BeamAttackSensor());
        }
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.ARROW_LAUNCHER)) {
            sensors.add(new ArrowAttackBehaviour.ArrowAttackSensor());
        }
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.MELEE_ATTACK)) {
            sensors.add(new MeleeAttackBehaviour.MeleeAttackSensor());
        }
        if (functions.contains((Object)DroneBehaviour.BlockFunctions.PICKUP)) {
            sensors.add(new PickupBehaviour.PickupSensor());
        }
        return sensors;
    }

    private static float getThrust(RecordedBlock block, HashMap<class_2382, class_2680> frame) {
        boolean blocked;
        boolean isThruster = block.state().method_26164(TagContent.THRUSTER_BLOCKS);
        if (!isThruster) {
            return 0.0f;
        }
        boolean bl = blocked = frame.containsKey(block.localPos().method_23228()) || frame.containsKey(block.localPos().method_23227(2));
        if (blocked) {
            return 0.0f;
        }
        class_2680 state = block.state();
        if (state.method_26164(TagContent.LOW_THRUSTER)) {
            return 10.0f;
        }
        if (state.method_26164(TagContent.MEDIUM_THRUSTER)) {
            return 25.0f;
        }
        if (state.method_26164(TagContent.HIGH_THRUSTER)) {
            return 40.0f;
        }
        if (state.method_26164(TagContent.ULTRA_THRUSTER)) {
            return 60.0f;
        }
        Drones.LOGGER.warn("Found thruster with thruster tag, but without a thrust strength tag: " + String.valueOf(state));
        return 0.0f;
    }
}

