/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import rearth.drone.DroneServerData;
import rearth.drone.RecordedBlock;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.drone.behaviour.DroneSensor;
import rearth.drone.behaviour.PlayerSwarmBehaviour;
import rearth.init.TagContent;
import rearth.util.Helpers;

public class MeleeAttackBehaviour
implements DroneBehaviour {
    private static final int MAX_RANGE = 25;
    private static final float HIT_RANGE = 1.25f;
    private static final int ATTACK_COOLDOWN = 21;
    private final class_1309 target;
    private final class_1657 owner;
    private final DroneServerData drone;
    private AttackPhase phase;
    private int attackCooldown = 0;

    public MeleeAttackBehaviour(class_1309 target, class_1657 owner, DroneServerData drone) {
        this.target = target;
        this.owner = owner;
        this.drone = drone;
        this.phase = AttackPhase.MOVING_IN;
    }

    @Override
    public void tick() {
        switch (this.phase.ordinal()) {
            case 0: {
                this.drone.targetPosition = this.target.method_33571();
                double dist = this.drone.currentPosition.method_1022(this.target.method_33571());
                double playerDist = this.drone.currentPosition.method_1022(this.owner.method_33571());
                this.attackCooldown = 0;
                if (dist > 25.0 || playerDist > 25.0) {
                    this.phase = AttackPhase.MOVING_HOME;
                    break;
                }
                if (!(dist < 1.25)) break;
                this.phase = AttackPhase.ATTACKING;
                break;
            }
            case 1: {
                double dist = this.drone.currentPosition.method_1022(this.target.method_33571());
                if (dist > 2.5) {
                    this.phase = AttackPhase.MOVING_IN;
                    return;
                }
                if (!this.target.method_5732() || !this.target.method_5805() || this.target.method_31481()) {
                    this.phase = AttackPhase.MOVING_HOME;
                    return;
                }
                this.drone.targetPosition = this.target.method_33571();
                if (this.attackCooldown < 0) {
                    int damage = 2;
                    this.target.method_5643(new class_1282((class_6880)this.owner.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42320), (class_1297)this.owner), (float)damage);
                    this.attackCooldown = 21;
                    class_1937 class_19372 = this.owner.method_37908();
                    if (!(class_19372 instanceof class_3218)) break;
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_243 middle = this.drone.currentPosition.method_1019(this.target.method_33571()).method_1021(0.5);
                    class_243 forward = this.target.method_33571().method_1020(this.drone.currentPosition).method_1029();
                    serverWorld.method_14199((class_2394)class_2398.field_11227, middle.field_1352, middle.field_1351, middle.field_1350, 1, forward.field_1352, forward.field_1351, forward.field_1350, (double)0.2f);
                    break;
                }
                --this.attackCooldown;
                break;
            }
            case 2: {
                this.drone.targetPosition = this.owner.method_33571().method_1031(0.0, 0.5, 0.0);
                double dist = this.drone.currentPosition.method_1022(this.owner.method_33571());
                if (!(dist < 2.5)) break;
                this.finishTask();
            }
        }
    }

    public void finishTask() {
        this.drone.setCurrentTask(new PlayerSwarmBehaviour(this.drone, this.owner));
    }

    @Override
    public float getCurrentYaw() {
        if (this.phase == AttackPhase.MOVING_HOME) {
            return Helpers.calculateYaw(this.drone.currentPosition, this.owner.method_33571());
        }
        if (this.phase == AttackPhase.ATTACKING) {
            float progress = (float)this.attackCooldown / 21.0f;
            return Helpers.calculateYaw(this.drone.currentPosition, this.target.method_33571()) + progress * 90.0f;
        }
        return Helpers.calculateYaw(this.drone.currentPosition, this.target.method_33571());
    }

    @Override
    public float getExtraRoll() {
        if (this.phase == AttackPhase.ATTACKING) {
            long time = this.owner.method_37908().method_8510();
            return (float)(Math.sin((float)time / 2.0f) * 20.0);
        }
        return DroneBehaviour.super.getExtraRoll();
    }

    @Override
    public int getPriority() {
        return this.phase == AttackPhase.MOVING_HOME ? 3 : 80;
    }

    public static boolean isValid(RecordedBlock block, HashMap<class_2382, class_2680> frame) {
        boolean blockMatches = block.state().method_26164(TagContent.MELEE_DAMAGE);
        if (!blockMatches) {
            return false;
        }
        for (int i = 1; i < 8; ++i) {
            if (!frame.containsKey(block.localPos().method_35858(i))) continue;
            return false;
        }
        return true;
    }

    private static enum AttackPhase {
        MOVING_IN,
        ATTACKING,
        MOVING_HOME;

    }

    public static class MeleeAttackSensor
    implements DroneSensor {
        @Override
        public int getPriority() {
            return 40;
        }

        @Override
        public boolean sense(DroneServerData drone, class_1657 player) {
            class_1937 world = player.method_37908();
            int entityRange = 16;
            class_243 playerHead = player.method_33571();
            List<class_1309> targets = world.method_8390(class_1309.class, new class_238(playerHead.field_1352 - (double)entityRange, playerHead.field_1351 - (double)entityRange, playerHead.field_1350 - (double)entityRange, playerHead.field_1352 + (double)entityRange, playerHead.field_1351 + (double)entityRange, playerHead.field_1350 + (double)entityRange), class_1301.field_6157.and(class_1301.field_6156));
            targets.sort(Comparator.comparingDouble(entity -> entity.method_5707(playerHead)));
            targets = targets.stream().filter(target -> target.method_5805() && !target.method_31481() && target instanceof class_1569).toList();
            if (!targets.isEmpty()) {
                drone.setCurrentTask(new MeleeAttackBehaviour(targets.getFirst(), player, drone));
                return true;
            }
            return false;
        }
    }
}

