/*
 * Decompiled with CFR 0.152.
 */
package rearth.drone.behaviour;

import net.minecraft.class_1657;
import net.minecraft.class_243;
import rearth.drone.DroneController;
import rearth.drone.DroneServerData;
import rearth.drone.behaviour.DroneBehaviour;
import rearth.util.Helpers;

public class PlayerSwarmBehaviour
implements DroneBehaviour {
    private final DroneServerData drone;
    private final class_1657 owner;

    public PlayerSwarmBehaviour(DroneServerData drone, class_1657 owner) {
        this.drone = drone;
        this.owner = owner;
    }

    @Override
    public void tick() {
        if (this.owner.method_31481()) {
            this.drone.setCurrentTask(null);
        }
        this.drone.targetPosition = PlayerSwarmBehaviour.getIdlePositionTarget(this.owner);
    }

    @Override
    public float getCurrentYaw() {
        double playerDist = this.drone.currentPosition.method_1022(this.owner.method_33571());
        if (playerDist > 5.0) {
            return Helpers.calculateYaw(this.drone.currentPosition, this.owner.method_33571());
        }
        return this.owner.field_6241;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public static class_243 getIdlePositionTarget(class_1657 player) {
        class_243 playerHead = player.method_33571();
        class_243 overheadCenter = playerHead.method_1031(0.0, 0.5, 0.0);
        double playerYaw = Math.toRadians(player.field_6283 - 90.0f);
        class_243 playerBackDir = new class_243(Math.cos(playerYaw), 0.0, Math.sin(playerYaw)).method_1029();
        long time = player.method_37908().method_8510();
        float sampledX = (float)time / 100.0f;
        double x = DroneController.SIMPLEX.method_15433((double)sampledX, 0.0);
        double y = DroneController.SIMPLEX.method_15433((double)sampledX, 5000.0);
        double z = DroneController.SIMPLEX.method_15433((double)(sampledX + 5000.0f), 5000.0);
        class_243 offset = new class_243(x, y / 3.0, z);
        return overheadCenter.method_1019(offset.method_1021(1.0)).method_1019(playerBackDir.method_1021((double)0.9f));
    }
}

