/*
 * Decompiled with CFR 0.152.
 */
package rearth.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class FloodFill {
    public static List<class_2338> Run(class_1937 world, class_2338 start, Predicate<class_2680> filter, Predicate<class_2338> positionFilter, int maxCount, boolean allowDiagonal) {
        HashSet<class_2338> nextSet;
        HashSet<class_2338> checked = new HashSet<class_2338>();
        ArrayList<class_2338> results = new ArrayList<class_2338>();
        HashSet<class_2338> open = new HashSet<class_2338>();
        open.add(start);
        do {
            nextSet = new HashSet<class_2338>();
            for (class_2338 checkPos : open) {
                if (checked.contains(checkPos)) continue;
                checked.add(checkPos);
                class_2680 checkState = world.method_8320(checkPos);
                if (!filter.test(checkState)) continue;
                results.add(checkPos);
                nextSet.addAll(Stream.of(FloodFill.GetNeighbors(checkPos, allowDiagonal)).filter(positionFilter).toList());
            }
        } while (!(open = nextSet).isEmpty() && results.size() <= maxCount);
        return results;
    }

    public static class_2338[] GetNeighbors(class_2338 from, boolean diagonal) {
        return diagonal ? FloodFill.GetNeighborsDiagonal(from) : FloodFill.GetNeighbors(from);
    }

    public static class_2338[] GetNeighbors(class_2338 from) {
        return new class_2338[]{from.method_10084(), from.method_10074(), from.method_10095(), from.method_10078(), from.method_10072(), from.method_10067()};
    }

    public static class_2338[] GetNeighborsDiagonal(class_2338 from) {
        return new class_2338[]{from.method_10084(), from.method_10074(), from.method_10095(), from.method_10078(), from.method_10072(), from.method_10067(), from.method_10095().method_10078(), from.method_10078().method_10072(), from.method_10072().method_10067(), from.method_10067().method_10095(), from.method_10095().method_10084(), from.method_10078().method_10084(), from.method_10072().method_10084(), from.method_10067().method_10084(), from.method_10095().method_10074(), from.method_10078().method_10074(), from.method_10072().method_10074(), from.method_10067().method_10074()};
    }

    public static class_2338[] GetHorizontalNeighbors(class_2338 from) {
        return new class_2338[]{from.method_10095(), from.method_10078(), from.method_10072(), from.method_10067()};
    }
}

