/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.datagen;

import com.phantomwing.choppersdelight.Compatibility;
import com.phantomwing.choppersdelight.block.ModBlocks;
import com.phantomwing.choppersdelight.utils.BlockUtils;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockModelProvider
extends BlockModelProvider {
    public ModBlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "choppersdelight", existingFileHelper);
    }

    protected void registerModels() {
        ModBlocks.MINECRAFT_CUTTING_BOARDS.forEach(supplier -> this.cuttingBoardModel((Supplier<Block>)supplier, "choppersdelight"));
        ModBlocks.BIOMES_O_PLENTY_CUTTING_BOARDS.forEach(supplier -> this.cuttingBoardModel((Supplier<Block>)supplier, Compatibility.BIOMES_O_PLENTY_MOD_ID));
        ModBlocks.BIOMES_WEVE_GONE_CUTTING_BOARDS.forEach(supplier -> this.cuttingBoardModel((Supplier<Block>)supplier, Compatibility.BIOMES_WEVE_GONE_MOD_ID));
    }

    private BlockModelBuilder cuttingBoardModel(Supplier<Block> blockSupplier, String modId) {
        Block block = blockSupplier.get();
        ResourceLocation blockTexture = BlockUtils.getResourceLocation(modId, blockSupplier.get());
        String blockModelName = modId + ":" + BlockUtils.getName(block);
        ResourceLocation parentModel = BlockUtils.getResourceLocation("farmersdelight", (Block)vectorwing.farmersdelight.common.registry.ModBlocks.CUTTING_BOARD.get());
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(blockModelName, parentModel)).texture("particle", blockTexture)).texture("top", blockTexture);
    }
}

