/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.datagen.loot;

import com.phantomwing.choppersdelight.Compatibility;
import com.phantomwing.choppersdelight.block.ModBlocks;
import com.phantomwing.choppersdelight.datagen.providers.LootTableSubProviderWithConditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BlockLootTables
implements LootTableSubProviderWithConditions {
    protected final HolderLookup.Provider registries;
    protected final Set<Item> explosionResistant = Set.of();
    protected final FeatureFlagSet enabledFeatures = FeatureFlags.REGISTRY.allFlags();
    protected final Map<ResourceKey<LootTable>, WithConditions<LootTable.Builder>> map = new HashMap<ResourceKey<LootTable>, WithConditions<LootTable.Builder>>();

    public BlockLootTables(HolderLookup.Provider lookupProvider) {
        this.registries = lookupProvider;
    }

    protected void generateLootTables() {
        ModBlocks.MINECRAFT_CUTTING_BOARDS.forEach(this::dropSelf);
        ModBlocks.BIOMES_O_PLENTY_CUTTING_BOARDS.forEach(blockSupplier -> this.dropSelfOptional((Supplier<Block>)blockSupplier, Compatibility.BIOMES_O_PLENTY_MOD_ID));
        ModBlocks.BIOMES_WEVE_GONE_CUTTING_BOARDS.forEach(blockSupplier -> this.dropSelfOptional((Supplier<Block>)blockSupplier, Compatibility.BIOMES_WEVE_GONE_MOD_ID));
        this.dropNothing((Supplier<Block>)ModBlocks.DECORATED_CUTTING_BOARD);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        Stream<Block> blocks = this.getKnownBlocksForRegistry(ModBlocks.BLOCKS);
        Stream<Block> biomesOPlentyBlocks = this.getKnownBlocksForRegistry(ModBlocks.BIOMES_O_PLENTY_BLOCKS);
        Stream<Block> biomesWeveGoneBlocks = this.getKnownBlocksForRegistry(ModBlocks.BIOMES_WEVE_GONE_BLOCKS);
        Stream<Block> concat = Stream.concat(biomesOPlentyBlocks, biomesWeveGoneBlocks);
        return Stream.concat(blocks, concat).toList();
    }

    private Stream<Block> getKnownBlocksForRegistry(DeferredRegister.Blocks registry) {
        return registry.getEntries().stream().map(DeferredHolder::value);
    }

    private void dropNothing(Supplier<Block> blockSupplier) {
        Block block = blockSupplier.get();
        this.add((ResourceKey<LootTable>)block.getLootTable(), LootTable.lootTable(), new ICondition[0]);
    }

    private void dropSelf(Supplier<Block> blockSupplier) {
        Block block = blockSupplier.get();
        this.add((ResourceKey<LootTable>)block.getLootTable(), this.createCuttingBoardLootTable((ItemLike)block), new ICondition[0]);
    }

    private void dropSelfOptional(Supplier<Block> blockSupplier, String modId) {
        Block block = blockSupplier.get();
        this.add((ResourceKey<LootTable>)block.getLootTable(), this.createCuttingBoardLootTable((ItemLike)block), new ICondition[]{new ModLoadedCondition(modId)});
    }

    public void add(ResourceKey<LootTable> modifier, LootTable.Builder instance, List<ICondition> conditions) {
        this.map.put(modifier, (WithConditions<LootTable.Builder>)new WithConditions(conditions, (Object)instance));
    }

    public void add(ResourceKey<LootTable> modifier, LootTable.Builder instance, ICondition ... conditions) {
        this.add(modifier, instance, Arrays.asList(conditions));
    }

    public LootTable.Builder createCuttingBoardLootTable(ItemLike item) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition(item, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item))));
    }

    protected <T extends ConditionUserBuilder<T>> T applyExplosionCondition(ItemLike item, ConditionUserBuilder<T> conditionBuilder) {
        return (T)(!this.explosionResistant.contains(item.asItem()) ? conditionBuilder.when(ExplosionCondition.survivesExplosion()) : conditionBuilder.unwrap());
    }

    @Override
    public void generate(BiConsumer<ResourceKey<LootTable>, WithConditions<LootTable.Builder>> output) {
        this.generateLootTables();
        HashSet<ResourceKey> set = new HashSet<ResourceKey>();
        for (Block block : this.getKnownBlocks()) {
            ResourceKey resourcekey;
            if (!block.isEnabled(this.enabledFeatures) || (resourcekey = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourcekey)) continue;
            WithConditions<LootTable.Builder> loottable$builder = this.map.remove(resourcekey);
            if (loottable$builder == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourcekey.location(), BuiltInRegistries.BLOCK.getKey((Object)block)));
            }
            output.accept((ResourceKey<LootTable>)resourcekey, loottable$builder);
        }
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.map.keySet()));
        }
    }
}

