/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.datagen.providers;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.phantomwing.choppersdelight.datagen.providers.LootTableSubProviderWithConditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LootTableProviderWithConditions
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProviderWithConditions(PackOutput output, Set<ResourceKey<LootTable>> requiredTables, List<SubProviderEntry> subProviders, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
        this.subProviders = subProviders;
        this.requiredTables = requiredTables;
        this.registries = registries;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput output) {
        return this.registries.thenCompose(p_323117_ -> this.run(output, (HolderLookup.Provider)p_323117_));
    }

    private CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider provider) {
        MappedRegistry writableregistry = new MappedRegistry(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap conditionsMap = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> LootTableProviderWithConditions.lambda$run$2(provider, (Map)map, (Map)conditionsMap, (WritableRegistry)writableregistry, arg_0));
        writableregistry.freeze();
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        HolderGetter.Provider holdergetter$provider = new RegistryAccess.ImmutableRegistryAccess(List.of(writableregistry)).freeze().asGetterLookup();
        ValidationContext validationcontext = new ValidationContext((ProblemReporter)problemreporter$collector, LootContextParamSets.ALL_PARAMS, holdergetter$provider);
        this.validate((WritableRegistry<LootTable>)writableregistry, validationcontext, problemreporter$collector);
        Multimap multimap = problemreporter$collector.get();
        if (!multimap.isEmpty()) {
            multimap.forEach((problemLoc, message) -> LOGGER.warn("Found validation problem in {}: {}", problemLoc, message));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableregistry.entrySet().stream().map(arg_0 -> this.lambda$run$4(provider, (Map)conditionsMap, output, arg_0)).toArray(CompletableFuture[]::new));
    }

    public List<SubProviderEntry> getTables() {
        return this.subProviders;
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        for (ResourceKey resourcekey : Sets.difference(this.requiredTables, (Set)writableregistry.registryKeySet())) {
            problemreporter$collector.report("Missing built-in table: " + String.valueOf(resourcekey.location()));
        }
        writableregistry.holders().forEach(p_335195_ -> ((LootTable)p_335195_.value()).validate(validationcontext.setParams(((LootTable)p_335195_.value()).getParamSet()).enterElement("{" + String.valueOf(p_335195_.key().location()) + "}", p_335195_.key())));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> lootTable) {
        return lootTable.location();
    }

    @NotNull
    public final String getName() {
        return "Loot Tables With Conditions";
    }

    private /* synthetic */ CompletableFuture lambda$run$4(HolderLookup.Provider provider, Map conditionsMap, CachedOutput output, Map.Entry lootTableEntry) {
        ResourceKey resourceKey = (ResourceKey)lootTableEntry.getKey();
        LootTable loottable = (LootTable)lootTableEntry.getValue();
        Path path = this.pathProvider.json(resourceKey.location());
        RegistryOps registryops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        JsonElement jsonelement = (JsonElement)LootTable.DIRECT_CODEC.encodeStart((DynamicOps)registryops, (Object)loottable).getOrThrow();
        JsonObject root = jsonelement.getAsJsonObject();
        List conditions = (List)conditionsMap.get(resourceKey);
        ICondition.writeConditions((HolderLookup.Provider)provider, (JsonObject)root, (List)conditions);
        return DataProvider.saveStable((CachedOutput)output, (JsonElement)root, (Path)path);
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider provider, Map map, Map conditionsMap, WritableRegistry writableregistry, SubProviderEntry subProviderEntry) {
        subProviderEntry.provider().apply(provider).generate((resourceKey, builderWithConditions) -> {
            ResourceLocation sequencedId = LootTableProviderWithConditions.sequenceIdForLootTable((ResourceKey<LootTable>)resourceKey);
            ResourceLocation resourceLocation = map.put(RandomSequence.seedForKey((ResourceLocation)sequencedId), sequencedId);
            if (resourceLocation != null) {
                String var10000 = String.valueOf(resourceLocation);
                Util.logAndPauseIfInIde((String)("Loot table random sequence seed collision on " + var10000 + " and " + String.valueOf(resourceKey.location())));
            }
            List conditions = builderWithConditions.conditions();
            conditionsMap.put(resourceKey, conditions);
            LootTable.Builder builder = (LootTable.Builder)builderWithConditions.carrier();
            builder.setRandomSequence(sequencedId);
            LootTable loottable = builder.setParamSet(subProviderEntry.paramSet).build();
            writableregistry.register(resourceKey, (Object)loottable, RegistrationInfo.BUILT_IN);
        });
    }

    public record SubProviderEntry(Function<HolderLookup.Provider, LootTableSubProviderWithConditions> provider, LootContextParamSet paramSet) {
    }
}

