/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.phantomwing.choppersdelight.block.custom.DecoratedCuttingBoardBlock;
import com.phantomwing.choppersdelight.block.entity.DecoratedCuttingBoardBlockEntity;
import com.phantomwing.choppersdelight.utils.BannerUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;

public class DecoratedCuttingBoardRenderer
implements BlockEntityRenderer<DecoratedCuttingBoardBlockEntity> {
    private final ModelPart bannerModelPart = BannerUtils.initializeBannerModelPart();

    public DecoratedCuttingBoardRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull DecoratedCuttingBoardBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Direction direction = ((Direction)blockEntity.getBlockState().getValue((Property)DecoratedCuttingBoardBlock.FACING)).getOpposite();
        this.renderBoard(direction, blockEntity, partialTicks, poseStack, buffer, light, overlay);
        BannerUtils.renderBanner(poseStack, buffer, this.bannerModelPart, light, overlay, direction, blockEntity);
        this.renderBoardContent(blockEntity, partialTicks, poseStack, buffer, light, overlay);
    }

    private void renderBoard(Direction direction, @Nonnull DecoratedCuttingBoardBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Level level = blockEntity.getLevel();
        int seed = (int)blockEntity.getBlockPos().asLong();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack board = blockEntity.getCuttingBoard();
        if (board != null) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            float f = -direction.toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(f));
            poseStack.scale(2.0f, 2.0f, 2.0f);
            itemRenderer.renderStatic(board, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, level, seed);
            poseStack.popPose();
        }
    }

    private void renderBoardContent(@Nonnull DecoratedCuttingBoardBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Item item;
        ItemStack board = blockEntity.getCuttingBoard();
        if (board != null && (item = board.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState oldBlockState = blockEntity.getBlockState();
            BlockState blockState = blockItem.getBlock().defaultBlockState();
            blockState = (BlockState)blockState.setValue((Property)CuttingBoardBlock.FACING, (Comparable)((Direction)oldBlockState.getValue((Property)DecoratedCuttingBoardBlock.FACING)));
            blockState = (BlockState)blockState.setValue((Property)CuttingBoardBlock.WATERLOGGED, (Comparable)((Boolean)oldBlockState.getValue((Property)DecoratedCuttingBoardBlock.WATERLOGGED)));
            CuttingBoardBlockEntity cuttingBoard = new CuttingBoardBlockEntity(blockEntity.getBlockPos(), blockState);
            cuttingBoard.addItem(blockEntity.getStoredItem().copy());
            BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            BlockEntityRenderer boardRenderer = dispatcher.getRenderer((BlockEntity)cuttingBoard);
            if (boardRenderer != null) {
                poseStack.pushPose();
                boardRenderer.render((BlockEntity)cuttingBoard, partialTicks, poseStack, buffer, light, overlay);
                poseStack.popPose();
            }
        }
    }
}

