/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.block.entity;

import com.phantomwing.choppersdelight.block.ModBlockEntityTypes;
import com.phantomwing.choppersdelight.block.custom.DecoratedCuttingBoardBlock;
import com.phantomwing.choppersdelight.component.DecoratedCuttingBoardData;
import com.phantomwing.choppersdelight.component.ModDataComponents;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.advancement.CuttingBoardTrigger;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipeInput;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.CommonTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackHandler;

public class DecoratedCuttingBoardBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory;
    private final class_1863.class_7266<CuttingBoardRecipeInput, CuttingBoardRecipe> quickCheck;
    private boolean isItemCarvingBoard = false;
    private class_1799 cuttingBoard = class_1799.field_8037;
    private class_1799 banner = class_1799.field_8037;

    public DecoratedCuttingBoardBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.DECORATED_CUTTING_BOARD.get(), pos, state);
        this.inventory = this.createHandler();
        this.quickCheck = class_1863.method_42302((class_3956)((class_3956)ModRecipeTypes.CUTTING.get()));
    }

    public static void init() {
        ItemStorage.SIDED.registerForBlockEntity(DecoratedCuttingBoardBlockEntity::getStorage, ModBlockEntityTypes.DECORATED_CUTTING_BOARD.get());
    }

    @NotNull
    public Storage<ItemVariant> getStorage(@Nullable class_2350 side) {
        return this.getInventory();
    }

    public void method_11014(@NotNull class_2487 compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.isItemCarvingBoard = compoundTag.method_10577("IsItemCarved");
        this.inventory.deserializeNBT(provider, compoundTag.method_10562("Inventory"));
        this.cuttingBoard = compoundTag.method_10545("CuttingBoardStack") ? class_1799.method_57359((class_7225.class_7874)provider, (class_2487)compoundTag.method_10562("CuttingBoardStack")) : new class_1799((class_1935)ModItems.CUTTING_BOARD.get());
        this.banner = compoundTag.method_10545("BannerStack") ? class_1799.method_57359((class_7225.class_7874)provider, (class_2487)compoundTag.method_10562("BannerStack")) : new class_1799((class_1935)class_1802.field_8539);
    }

    public void method_11007(@NotNull class_2487 compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10566("Inventory", (class_2520)this.inventory.serializeNBT(provider));
        compoundTag.method_10556("IsItemCarved", this.isItemCarvingBoard);
        if (!this.cuttingBoard.method_7960()) {
            compoundTag.method_10566("CuttingBoardStack", this.cuttingBoard.method_57376(provider, (class_2520)new class_2487()));
        }
        if (!this.banner.method_7960()) {
            compoundTag.method_10566("BannerStack", this.banner.method_57376(provider, (class_2520)new class_2487()));
        }
    }

    public boolean processStoredItemUsingTool(class_1799 toolStack, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.isItemCarvingBoard) {
            return false;
        }
        Optional<class_8786<CuttingBoardRecipe>> matchingRecipe = this.getMatchingRecipe(toolStack, player);
        matchingRecipe.ifPresent(recipe -> {
            List results = ((CuttingBoardRecipe)recipe.comp_1933()).rollResults(this.field_11863.field_9229, class_1890.method_8225((class_6880)this.field_11863.method_30349().method_30530(class_7924.field_41265).method_40290(class_1893.field_9130), (class_1799)toolStack));
            for (class_1799 resultStack : results) {
                class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)DecoratedCuttingBoardBlock.FACING)).method_10160();
                ItemUtils.spawnItemEntity((class_1937)this.field_11863, (class_1799)resultStack.method_7972(), (double)((double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2), (double)((double)this.field_11867.method_10264() + 0.2), (double)((double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2), (double)((float)direction.method_10148() * 0.2f), (double)0.0, (double)((float)direction.method_10165() * 0.2f));
            }
            if (!this.field_11863.field_9236) {
                toolStack.method_7956(1, (class_3218)this.field_11863, (class_3222)player, item -> {});
            }
            this.playProcessingSound(((CuttingBoardRecipe)recipe.comp_1933()).getSoundEvent().orElse(null), toolStack, this.getStoredItem());
            this.removeItem();
            if (player instanceof class_3222) {
                ((CuttingBoardTrigger)ModAdvancements.USE_CUTTING_BOARD.get()).trigger((class_3222)player);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<class_8786<CuttingBoardRecipe>> getMatchingRecipe(class_1799 toolStack, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        Optional recipe = this.quickCheck.method_42303((class_9695)new CuttingBoardRecipeInput(this.getStoredItem(), toolStack), this.field_11863);
        if (recipe.isPresent()) {
            if (((CuttingBoardRecipe)((class_8786)recipe.get()).comp_1933()).getTool().method_8093(toolStack)) {
                return recipe;
            }
            if (player != null) {
                player.method_7353((class_2561)TextUtils.getTranslation((String)"block.cutting_board.invalid_tool", (Object[])new Object[0]), true);
            }
        } else if (player != null) {
            player.method_7353((class_2561)TextUtils.getTranslation((String)"block.cutting_board.invalid_item", (Object[])new Object[0]), true);
        }
        return Optional.empty();
    }

    public void playProcessingSound(@Nullable class_3414 sound, class_1799 tool, class_1799 boardItem) {
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
            this.playSound(class_3417.field_14975, 1.0f, 1.0f);
        } else if (tool.method_31573(CommonTags.TOOLS_KNIFE)) {
            this.playSound((class_3414)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else {
            class_1792 class_17922 = boardItem.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_2248 block = blockItem.method_7711();
                class_2498 soundType = block.method_9564().method_26231();
                this.playSound(soundType.method_10595(), 1.0f, 0.8f);
            } else {
                this.playSound(class_3417.field_15215, 1.0f, 0.8f);
            }
        }
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
        }
    }

    public boolean addItem(class_1799 itemStack) {
        if (this.isEmpty() && !itemStack.method_7960()) {
            this.inventory.setStackInSlot(0, itemStack.method_7971(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(class_1799 tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            class_1799 item = this.getStoredItem().method_7971(1);
            this.inventoryChanged();
            return item;
        }
        return class_1799.field_8037;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public class_1799 getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).method_7960();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    public void method_11012() {
        super.method_11012();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                DecoratedCuttingBoardBlockEntity.this.inventoryChanged();
            }
        };
    }

    public void loadFromItemStack(class_1799 stack) {
        DecoratedCuttingBoardData data = (DecoratedCuttingBoardData)stack.method_57824(ModDataComponents.DECORATED_CUTTING_BOARD_DATA.get());
        if (data != null) {
            this.cuttingBoard = data.cuttingBoard().method_7972();
            this.banner = data.banner().method_7972();
        } else {
            this.cuttingBoard = new class_1799((class_1935)ModItems.CUTTING_BOARD.get());
            this.banner = new class_1799((class_1935)class_1802.field_8539);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        this.method_11007(tag, provider);
        return tag;
    }

    public class_1799 getItem() {
        class_1799 itemstack = new class_1799((class_1935)com.phantomwing.choppersdelight.item.ModItems.DECORATED_CUTTING_BOARD.get());
        itemstack.method_57379(ModDataComponents.DECORATED_CUTTING_BOARD_DATA.get(), (Object)new DecoratedCuttingBoardData(this.cuttingBoard.method_7972(), this.banner.method_7972()));
        return itemstack;
    }

    public class_1799 getCuttingBoard() {
        return this.cuttingBoard;
    }

    public class_1799 getBanner() {
        return this.banner;
    }
}

