/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.datagen;

import com.phantomwing.choppersdelight.datagen.ModBlockModelProvider;
import com.phantomwing.choppersdelight.datagen.ModBlockStateProvider;
import com.phantomwing.choppersdelight.datagen.ModBlockTagsProvider;
import com.phantomwing.choppersdelight.datagen.ModItemModelProvider;
import com.phantomwing.choppersdelight.datagen.ModItemTagsProvider;
import com.phantomwing.choppersdelight.datagen.ModLootTableProvider;
import com.phantomwing.choppersdelight.datagen.ModRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="choppersdelight", value={Dist.CLIENT})
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(output, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(output, existingFileHelper));
        ModBlockTagsProvider blockTagsProvider = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(output, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
    }
}

