/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.choppersdelight.datagen;

import com.phantomwing.choppersdelight.Compatibility;
import com.phantomwing.choppersdelight.block.ModBlocks;
import com.phantomwing.choppersdelight.utils.BlockUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.common.block.BasketBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "choppersdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModBlocks.MINECRAFT_CUTTING_BOARDS.forEach(supplier -> this.cuttingBoardBlock((Supplier<Block>)supplier, "choppersdelight"));
        ModBlocks.BIOMES_O_PLENTY_CUTTING_BOARDS.forEach(supplier -> this.cuttingBoardBlock((Supplier<Block>)supplier, Compatibility.BIOMES_O_PLENTY_MOD_ID));
        ModBlocks.BIOMES_WEVE_GONE_CUTTING_BOARDS.forEach(supplier -> this.cuttingBoardBlock((Supplier<Block>)supplier, Compatibility.BIOMES_WEVE_GONE_MOD_ID));
        this.cuttingBoardBlock((Supplier<Block>)ModBlocks.DECORATED_CUTTING_BOARD, "choppersdelight");
    }

    private void cuttingBoardBlock(Supplier<Block> supplier, String modId) {
        Block block = supplier.get();
        this.customHorizontalBlock(block, $ -> BlockUtils.getModel(this.models(), modId, block), new Property[]{BasketBlock.WATERLOGGED});
    }

    private void customHorizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build(), ignored);
    }
}

